/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.ParameterValidator;

public class RecurrenceId
extends DateProperty {
    private static final long serialVersionUID = 4456883817126011006L;

    public RecurrenceId() {
        super("RECURRENCE-ID");
        this.setDate(new DateTime());
    }

    public RecurrenceId(ParameterList parameterList, String string) throws ParseException {
        super("RECURRENCE-ID", parameterList);
        this.setValue(string);
    }

    public RecurrenceId(Date date) {
        super("RECURRENCE-ID");
        this.setDate(date);
    }

    public RecurrenceId(ParameterList parameterList, Date date) {
        super("RECURRENCE-ID", parameterList);
        this.setDate(date);
    }

    public final void validate() throws ValidationException {
        super.validate();
        ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
        Parameter parameter = this.getParameters().getParameter("VALUE");
        if (parameter != null && !Value.DATE_TIME.equals(parameter) && !Value.DATE.equals(parameter)) {
            throw new ValidationException("Parameter [VALUE] is invalid");
        }
        if (this.isUtc()) {
            ParameterValidator.getInstance().assertNone("TZID", this.getParameters());
        } else {
            ParameterValidator.getInstance().assertOneOrLess("TZID", this.getParameters());
        }
        ParameterValidator.getInstance().assertOneOrLess("RANGE", this.getParameters());
    }
}

