/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;

public final class PropertyValidator {
    private static PropertyValidator instance = new PropertyValidator();

    private PropertyValidator() {
    }

    public void assertOneOrLess(String string, PropertyList propertyList) throws ValidationException {
        if (propertyList.getProperties(string).size() > 1) {
            throw new ValidationException("Property [" + string + "] must only be specified once");
        }
    }

    public void assertOneOrMore(String string, PropertyList propertyList) throws ValidationException {
        if (propertyList.getProperties(string).size() < 1) {
            throw new ValidationException("Property [" + string + "] must be specified at least once");
        }
    }

    public void assertOne(String string, PropertyList propertyList) throws ValidationException {
        if (propertyList.getProperties(string).size() != 1) {
            throw new ValidationException("Property [" + string + "] must be specified once");
        }
    }

    public void assertNone(String string, PropertyList propertyList) throws ValidationException {
        if (propertyList.getProperties(string).size() > 0) {
            throw new ValidationException("Property [" + string + "] is not applicable");
        }
    }

    public static PropertyValidator getInstance() {
        return instance;
    }
}

