/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.util.regex.Pattern;

public final class Strings {
    private static final Pattern CHECK_ESCAPE = Pattern.compile("[,;\"\n\\\\]");
    private static final Pattern CHECK_UNESCAPE = Pattern.compile("\\\\");
    private static final Pattern ESCAPE_PATTERN_1 = Pattern.compile("([,;\"])");
    private static final Pattern ESCAPE_PATTERN_2 = Pattern.compile("[\r\n]+");
    private static final Pattern ESCAPE_PATTERN_3 = Pattern.compile("\\\\");
    private static final Pattern UNESCAPE_PATTERN_1 = Pattern.compile("\\\\([,;\"])");
    private static final Pattern UNESCAPE_PATTERN_2 = Pattern.compile("\\\\n", 2);
    private static final Pattern UNESCAPE_PATTERN_3 = Pattern.compile("\\\\\\\\");

    private Strings() {
    }

    public static String quote(Object object) {
        if (object != null) {
            return "\"" + object + "\"";
        }
        return "\"\"";
    }

    public static String unquote(String string) {
        if (string != null && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(0, string.length() - 1).substring(1);
        }
        return string;
    }

    public static String escape(String string) {
        if (string != null && CHECK_ESCAPE.matcher(string).find()) {
            return ESCAPE_PATTERN_1.matcher(ESCAPE_PATTERN_2.matcher(ESCAPE_PATTERN_3.matcher(string).replaceAll("\\\\\\\\")).replaceAll("\\\\n")).replaceAll("\\\\$1");
        }
        return string;
    }

    public static String unescape(String string) {
        if (string != null && CHECK_UNESCAPE.matcher(string).find()) {
            return UNESCAPE_PATTERN_3.matcher(UNESCAPE_PATTERN_2.matcher(UNESCAPE_PATTERN_1.matcher(string).replaceAll("$1")).replaceAll("\n")).replaceAll("\\\\");
        }
        return string;
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

