/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphScene<N, E>
extends ObjectScene {
    private HashSet<N> nodes = new HashSet();
    private Set<N> nodesUm = Collections.unmodifiableSet(this.nodes);
    private HashSet<E> edges = new HashSet();
    private Set<E> edgesUm = Collections.unmodifiableSet(this.edges);
    private HashMap<E, N> edgeSourceNodes = new HashMap();
    private HashMap<E, N> edgeTargetNodes = new HashMap();
    private HashMap<N, List<E>> nodeInputEdges = new HashMap();
    private HashMap<N, List<E>> nodeOutputEdges = new HashMap();

    public final Widget addNode(N node) {
        assert (node != null && !this.nodes.contains(node));
        Widget widget = this.attachNodeWidget(node);
        this.addObject(node, widget);
        this.nodes.add(node);
        this.nodeInputEdges.put(node, new ArrayList());
        this.nodeOutputEdges.put(node, new ArrayList());
        this.notifyNodeAdded(node, widget);
        return widget;
    }

    public final void removeNode(N node) {
        assert (node != null && this.nodes.contains(node));
        for (E edge : this.findNodeEdges(node, true, false)) {
            this.setEdgeSource(edge, null);
        }
        for (E edge : this.findNodeEdges(node, false, true)) {
            this.setEdgeTarget(edge, null);
        }
        this.nodeInputEdges.remove(node);
        this.nodeOutputEdges.remove(node);
        this.nodes.remove(node);
        Widget widget = this.findWidget(node);
        this.removeObject(node);
        this.detachNodeWidget(node, widget);
    }

    public final void removeNodeWithEdges(N node) {
        for (E edge : this.findNodeEdges(node, true, true)) {
            if (!this.isEdge(edge)) continue;
            this.removeEdge(edge);
        }
        this.removeNode(node);
    }

    public final Collection<N> getNodes() {
        return this.nodesUm;
    }

    public final Widget addEdge(E edge) {
        assert (edge != null && !this.edges.contains(edge));
        Widget widget = this.attachEdgeWidget(edge);
        this.addObject(edge, widget);
        this.edges.add(edge);
        this.notifyEdgeAdded(edge, widget);
        return widget;
    }

    public final void removeEdge(E edge) {
        assert (edge != null && this.edges.contains(edge));
        this.setEdgeSource(edge, null);
        this.setEdgeTarget(edge, null);
        this.edges.remove(edge);
        this.edgeSourceNodes.remove(edge);
        this.edgeTargetNodes.remove(edge);
        Widget widget = this.findWidget(edge);
        this.removeObject(edge);
        this.detachEdgeWidget(edge, widget);
    }

    public final Collection<E> getEdges() {
        return this.edgesUm;
    }

    public final void setEdgeSource(E edge, N sourceNode) {
        assert (edge != null && this.edges.contains(edge));
        if (sourceNode != null) assert (this.nodes.contains(sourceNode));
        N oldNode = this.edgeSourceNodes.put(edge, sourceNode);
        if (GeomUtil.equals(oldNode, sourceNode)) {
            return;
        }
        if (oldNode != null) {
            this.nodeOutputEdges.get(oldNode).remove(edge);
        }
        if (sourceNode != null) {
            this.nodeOutputEdges.get(sourceNode).add(edge);
        }
        this.attachEdgeSourceAnchor(edge, oldNode, sourceNode);
    }

    public final void setEdgeTarget(E edge, N targetNode) {
        assert (edge != null && this.edges.contains(edge));
        if (targetNode != null) assert (this.nodes.contains(targetNode));
        N oldNode = this.edgeTargetNodes.put(edge, targetNode);
        if (GeomUtil.equals(oldNode, targetNode)) {
            return;
        }
        if (oldNode != null) {
            this.nodeInputEdges.get(oldNode).remove(edge);
        }
        if (targetNode != null) {
            this.nodeInputEdges.get(targetNode).add(edge);
        }
        this.attachEdgeTargetAnchor(edge, oldNode, targetNode);
    }

    public final N getEdgeSource(E edge) {
        return this.edgeSourceNodes.get(edge);
    }

    public final N getEdgeTarget(E edge) {
        return this.edgeTargetNodes.get(edge);
    }

    public final Collection<E> findNodeEdges(N node, boolean allowOutputEdges, boolean allowInputEdges) {
        ArrayList list = new ArrayList();
        if (allowInputEdges) {
            list.addAll(this.nodeInputEdges.get(node));
        }
        if (allowOutputEdges) {
            list.addAll(this.nodeOutputEdges.get(node));
        }
        return list;
    }

    public final Collection<E> findEdgesBetween(N sourceNode, N targetNode) {
        HashSet<E> list = new HashSet<E>();
        List<E> inputEdges = this.nodeInputEdges.get(targetNode);
        List<E> outputEdges = this.nodeOutputEdges.get(sourceNode);
        for (E edge : inputEdges) {
            if (!outputEdges.contains(edge)) continue;
            list.add(edge);
        }
        return list;
    }

    public boolean isNode(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.nodes.contains(object);
    }

    public boolean isEdge(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.edges.contains(object);
    }

    protected void notifyNodeAdded(N node, Widget widget) {
    }

    protected void notifyEdgeAdded(E edge, Widget widget) {
    }

    protected void detachNodeWidget(N node, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachEdgeWidget(E edge, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected abstract Widget attachNodeWidget(N var1);

    protected abstract Widget attachEdgeWidget(E var1);

    protected abstract void attachEdgeSourceAnchor(E var1, N var2, N var3);

    protected abstract void attachEdgeTargetAnchor(E var1, N var2, N var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringGraph
    extends GraphScene<String, String> {
    }
}

