/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.layout;

import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.AbsoluteLayout;
import org.netbeans.modules.visual.layout.CardLayout;
import org.netbeans.modules.visual.layout.DevolveWidgetLayout;
import org.netbeans.modules.visual.layout.FillLayout;
import org.netbeans.modules.visual.layout.SerialLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutFactory {
    private static final AbsoluteLayout LAYOUT_ABSOLUTE = new AbsoluteLayout();
    private static final FillLayout LAYOUT_FILL = new FillLayout();

    private LayoutFactory() {
    }

    public static Layout createAbsoluteLayout() {
        return LAYOUT_ABSOLUTE;
    }

    public static Layout createVerticalLayout() {
        return LayoutFactory.createVerticalLayout(null, 0);
    }

    public static Layout createVerticalLayout(SerialAlignment alignment, int gap) {
        return new SerialLayout(true, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createHorizontalLayout() {
        return LayoutFactory.createHorizontalLayout(null, 0);
    }

    public static Layout createHorizontalLayout(SerialAlignment alignment, int gap) {
        return new SerialLayout(false, alignment != null ? alignment : SerialAlignment.JUSTIFY, gap);
    }

    public static Layout createCardLayout(Widget cardLayoutWidget) {
        assert (cardLayoutWidget != null);
        return new CardLayout(cardLayoutWidget);
    }

    public static Widget getActiveCard(Widget cardLayoutWidget) {
        Layout layout = cardLayoutWidget.getLayout();
        return layout instanceof CardLayout ? ((CardLayout)layout).getActiveChildWidget() : null;
    }

    public static void setActiveCard(Widget widget, Widget activeChildWidget) {
        Layout layout = widget.getLayout();
        if (layout instanceof CardLayout) {
            ((CardLayout)layout).setActiveChildWidget(activeChildWidget);
        }
    }

    public static Layout createFillLayout() {
        return LAYOUT_FILL;
    }

    public static SceneLayout createDevolveWidgetLayout(Widget widget, Layout devolveLayout, boolean animate) {
        return new DevolveWidgetLayout(widget, devolveLayout, animate);
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphScene<N, E> graphScene, final GraphLayout<N, E> graphLayout) {
        assert (graphScene != null && graphLayout != null);
        return new SceneLayout(graphScene){

            protected void performLayout() {
                graphLayout.layoutGraph(graphScene);
            }
        };
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphPinScene<N, E, ?> graphPinScene, final GraphLayout<N, E> graphLayout) {
        assert (graphPinScene != null && graphLayout != null);
        return new SceneLayout(graphPinScene){

            protected void performLayout() {
                graphLayout.layoutGraph(graphPinScene);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionWidgetLayoutAlignment {
        NONE,
        CENTER,
        TOP_CENTER,
        BOTTOM_CENTER,
        CENTER_LEFT,
        CENTER_RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SerialAlignment {
        LEFT_TOP,
        CENTER,
        RIGHT_BOTTOM,
        JUSTIFY;

    }
}

