/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Color;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.anchor.PointShapeFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.vmd.VMDNodeBorder;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.Utilities;

public class VMDConnectionWidget
extends ConnectionWidget {
    private static final PointShape POINT_SHAPE_IMAGE = PointShapeFactory.createImagePointShape(Utilities.loadImage((String)"org/netbeans/modules/visual/resources/vmd-pin.png"));
    private static final Color COLOR_NORMAL = VMDNodeBorder.COLOR_BORDER;
    private static final Color COLOR_HOVERED = Color.BLACK;
    private static final Color COLOR_HIGHLIGHTED = new Color(49, 106, 197);

    public VMDConnectionWidget(Scene scene, Router router) {
        super(scene);
        this.setRouter(router);
        this.setSourceAnchorShape(AnchorShape.NONE);
        this.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.setPaintControlPoints(true);
        this.setState(ObjectState.createNormal());
    }

    public void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (state.isHovered()) {
            this.setForeground(COLOR_HOVERED);
        } else if (state.isSelected()) {
            this.setForeground(VMDNodeWidget.COLOR_SELECTED);
        } else if (state.isHighlighted()) {
            this.setForeground(COLOR_HIGHLIGHTED);
        } else if (state.isFocused()) {
            this.setForeground(COLOR_HOVERED);
        } else {
            this.setForeground(COLOR_NORMAL);
        }
        if (state.isSelected()) {
            this.setControlPointShape(PointShape.SQUARE_FILLED_SMALL);
            this.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
        } else {
            this.setControlPointShape(PointShape.NONE);
            this.setEndPointShape(POINT_SHAPE_IMAGE);
        }
    }
}

