/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDMinimizeAbility;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.vmd.VMDNodeBorder;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDNodeWidget
extends Widget
implements StateModel.Listener,
VMDMinimizeAbility {
    private static final Image IMAGE_EXPAND = Utilities.loadImage((String)"org/netbeans/modules/visual/resources/vmd-expand.png");
    private static final Image IMAGE_COLLAPSE = Utilities.loadImage((String)"org/netbeans/modules/visual/resources/vmd-collapse.png");
    private static final Border BORDER_NODE = new VMDNodeBorder();
    private static final Color BORDER_CATEGORY_BACKGROUND = new Color(13491704);
    private static final Border BORDER_MINIMIZE = BorderFactory.createRoundedBorder(2, 2, null, VMDNodeBorder.COLOR_BORDER);
    static final Color COLOR_SELECTED = new Color(7638208);
    static final Border BORDER = BorderFactory.createOpaqueBorder(2, 8, 2, 8);
    static final Border BORDER_HOVERED = BorderFactory.createLineBorder(2, 8, 2, 8, Color.BLACK);
    private Widget header;
    private ImageWidget minimizeWidget;
    private ImageWidget imageWidget;
    private LabelWidget nameWidget;
    private LabelWidget typeWidget;
    private VMDGlyphSetWidget glyphSetWidget;
    private SeparatorWidget pinsSeparator;
    private HashMap<String, Widget> pinCategoryWidgets = new HashMap();
    private Font fontPinCategory = this.getScene().getFont().deriveFont(10.0f);
    private StateModel stateModel = new StateModel(2);
    private Anchor nodeAnchor = new VMDNodeAnchor(this);

    public VMDNodeWidget(Scene scene) {
        super(scene);
        this.setOpaque(false);
        this.setBorder(BORDER_NODE);
        this.setLayout(LayoutFactory.createVerticalLayout());
        this.setMinimumSize(new Dimension(128, 8));
        this.header = new Widget(scene);
        this.header.setBorder(BORDER);
        this.header.setBackground(COLOR_SELECTED);
        this.header.setOpaque(false);
        this.header.setLayout(LayoutFactory.createHorizontalLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.addChild(this.header);
        this.minimizeWidget = new ImageWidget(scene, IMAGE_COLLAPSE);
        this.minimizeWidget.setCursor(Cursor.getPredefinedCursor(12));
        this.minimizeWidget.setBorder(BORDER_MINIMIZE);
        this.minimizeWidget.getActions().addAction(new ToggleMinimizedAction());
        this.header.addChild(this.minimizeWidget);
        this.imageWidget = new ImageWidget(scene);
        this.header.addChild(this.imageWidget);
        this.nameWidget = new LabelWidget(scene);
        this.nameWidget.setFont(scene.getDefaultFont().deriveFont(1));
        this.header.addChild(this.nameWidget);
        this.typeWidget = new LabelWidget(scene);
        this.typeWidget.setForeground(Color.BLACK);
        this.header.addChild(this.typeWidget);
        this.glyphSetWidget = new VMDGlyphSetWidget(scene);
        this.header.addChild(this.glyphSetWidget);
        this.pinsSeparator = new SeparatorWidget(scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.pinsSeparator.setForeground(BORDER_CATEGORY_BACKGROUND);
        this.addChild(this.pinsSeparator);
        Widget topLayer = new Widget(scene);
        this.addChild(topLayer);
        this.stateModel = new StateModel();
        this.stateModel.addListener(this);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    public boolean isMinimized() {
        return this.stateModel.getBooleanState();
    }

    public void setMinimized(boolean minimized) {
        this.stateModel.setBooleanState(minimized);
    }

    public void toggleMinimized() {
        this.stateModel.toggleBooleanState();
    }

    @Override
    public void stateChanged() {
        boolean minimized = this.stateModel.getBooleanState();
        Rectangle rectangle = minimized ? new Rectangle() : null;
        for (Widget widget : this.getChildren()) {
            if (widget == this.header || widget == this.pinsSeparator) continue;
            this.getScene().getSceneAnimator().animatePreferredBounds(widget, rectangle);
        }
        this.minimizeWidget.setImage(minimized ? IMAGE_EXPAND : IMAGE_COLLAPSE);
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (!previousState.isSelected() && state.isSelected()) {
            this.bringToFront();
        } else if (!previousState.isHovered() && state.isHovered()) {
            this.bringToFront();
        }
        this.header.setOpaque(state.isSelected());
        this.header.setBorder(state.isFocused() || state.isHovered() ? BORDER_HOVERED : BORDER);
    }

    public void setNodeImage(Image image) {
        this.imageWidget.setImage(image);
        this.revalidate();
    }

    public String getNodeName() {
        return this.nameWidget.getLabel();
    }

    public void setNodeName(String nodeName) {
        this.nameWidget.setLabel(nodeName);
    }

    public void setNodeType(String nodeType) {
        this.typeWidget.setLabel(nodeType != null ? "[" + nodeType + "]" : null);
    }

    public void attachPinWidget(Widget widget) {
        widget.setCheckClipping(true);
        this.addChild(widget);
        if (this.stateModel.getBooleanState()) {
            widget.setPreferredBounds(new Rectangle());
        }
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphSetWidget.setGlyphs(glyphs);
    }

    public void setNodeProperties(Image image, String nodeName, String nodeType, List<Image> glyphs) {
        this.setNodeImage(image);
        this.setNodeName(nodeName);
        this.setNodeType(nodeType);
        this.setGlyphs(glyphs);
    }

    public LabelWidget getNodeNameWidget() {
        return this.nameWidget;
    }

    public Anchor getNodeAnchor() {
        return this.nodeAnchor;
    }

    public Anchor createAnchorPin(Anchor anchor) {
        return AnchorFactory.createProxyAnchor(this.stateModel, anchor, this.nodeAnchor);
    }

    private List<Widget> getPinWidgets() {
        ArrayList<Widget> pins = new ArrayList<Widget>(this.getChildren());
        pins.remove(this.header);
        pins.remove(this.pinsSeparator);
        return pins;
    }

    public void sortPins(HashMap<String, List<Widget>> pinsCategories) {
        List<Widget> previousPins = this.getPinWidgets();
        ArrayList<Widget> unresolvedPins = new ArrayList<Widget>(previousPins);
        Iterator<Widget> iterator = unresolvedPins.iterator();
        while (iterator.hasNext()) {
            Widget widget = iterator.next();
            if (!this.pinCategoryWidgets.containsValue(widget)) continue;
            iterator.remove();
        }
        ArrayList<String> unusedCategories = new ArrayList<String>(this.pinCategoryWidgets.keySet());
        ArrayList<String> categoryNames = new ArrayList<String>(pinsCategories.keySet());
        Collections.sort(categoryNames);
        ArrayList<Widget> newWidgets = new ArrayList<Widget>();
        for (String categoryName : categoryNames) {
            if (categoryName == null) continue;
            unusedCategories.remove(categoryName);
            newWidgets.add(this.createPinCategoryWidget(categoryName));
            List<Widget> widgets = pinsCategories.get(categoryName);
            for (Widget widget : widgets) {
                if (!unresolvedPins.remove(widget)) continue;
                newWidgets.add(widget);
            }
        }
        if (!unresolvedPins.isEmpty()) {
            newWidgets.addAll(0, unresolvedPins);
        }
        for (String category : unusedCategories) {
            this.pinCategoryWidgets.remove(category);
        }
        this.removeChildren(previousPins);
        this.addChildren(newWidgets);
    }

    private Widget createPinCategoryWidget(String categoryDisplayName) {
        Widget w = this.pinCategoryWidgets.get(categoryDisplayName);
        if (w != null) {
            return w;
        }
        LabelWidget label = new LabelWidget(this.getScene(), categoryDisplayName);
        label.setOpaque(true);
        label.setBackground(BORDER_CATEGORY_BACKGROUND);
        label.setForeground(Color.GRAY);
        label.setFont(this.fontPinCategory);
        label.setAlignment(LabelWidget.Alignment.CENTER);
        label.setCheckClipping(true);
        if (this.stateModel.getBooleanState()) {
            label.setPreferredBounds(new Rectangle());
        }
        this.pinCategoryWidgets.put(categoryDisplayName, label);
        return label;
    }

    @Override
    public void collapseWidget() {
        this.stateModel.setBooleanState(true);
    }

    @Override
    public void expandWidget() {
        this.stateModel.setBooleanState(false);
    }

    public Widget getHeader() {
        return this.header;
    }

    private final class ToggleMinimizedAction
    extends WidgetAction.Adapter {
        private ToggleMinimizedAction() {
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            if (event.getButton() == 1 || event.getButton() == 2) {
                VMDNodeWidget.this.stateModel.toggleBooleanState();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }
    }
}

