/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Image;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMDPinWidget
extends Widget {
    private LabelWidget nameWidget;
    private VMDGlyphSetWidget glyphsWidget;
    private VMDNodeAnchor anchor;

    public VMDPinWidget(Scene scene) {
        super(scene);
        this.setBorder(VMDNodeWidget.BORDER);
        this.setBackground(VMDNodeWidget.COLOR_SELECTED);
        this.setOpaque(false);
        this.setLayout(LayoutFactory.createHorizontalLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.nameWidget = new LabelWidget(scene);
        this.addChild(this.nameWidget);
        this.glyphsWidget = new VMDGlyphSetWidget(scene);
        this.addChild(this.glyphsWidget);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.setOpaque(state.isSelected());
        this.setBorder(state.isFocused() || state.isHovered() ? VMDNodeWidget.BORDER_HOVERED : VMDNodeWidget.BORDER);
    }

    public Widget getPinNameWidget() {
        return this.nameWidget;
    }

    public void setPinName(String name) {
        this.nameWidget.setLabel(name);
    }

    public String getPinName() {
        return this.nameWidget.getLabel();
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphsWidget.setGlyphs(glyphs);
    }

    public void setProperties(String name, List<Image> glyphs) {
        this.setPinName(name);
        this.glyphsWidget.setGlyphs(glyphs);
    }

    public Anchor createAnchor() {
        if (this.anchor == null) {
            this.anchor = new VMDNodeAnchor(this, false);
        }
        return this.anchor;
    }
}

