/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ComponentWidget
extends Widget {
    private Component component;
    private boolean componentAdded;
    private boolean widgetAdded;
    private double zoomFactor = Double.MIN_VALUE;
    private ComponentSceneListener validateListener;
    private ComponentComponentListener componentListener;
    private boolean componentVisible = false;

    public ComponentWidget(Scene scene, Component component) {
        super(scene);
        this.component = component;
        this.validateListener = null;
        this.componentListener = new ComponentComponentListener();
        this.setComponentVisible(true);
    }

    public final Component getComponent() {
        return this.component;
    }

    public final boolean isComponentVisible() {
        return this.componentVisible;
    }

    public final void setComponentVisible(boolean componentVisible) {
        if (this.componentVisible == componentVisible) {
            return;
        }
        this.componentVisible = componentVisible;
        this.attach();
        this.revalidate();
    }

    protected final void notifyAdded() {
        this.widgetAdded = true;
        this.attach();
    }

    protected final void notifyRemoved() {
        this.widgetAdded = false;
    }

    private void attach() {
        if (this.validateListener != null) {
            return;
        }
        this.validateListener = new ComponentSceneListener();
        this.getScene().addSceneListener(this.validateListener);
    }

    private void detach() {
        if (this.validateListener == null) {
            return;
        }
        this.getScene().removeSceneListener(this.validateListener);
        this.validateListener = null;
    }

    protected final Rectangle calculateClientArea() {
        Dimension preferredSize = this.component.getPreferredSize();
        this.zoomFactor = this.getScene().getZoomFactor();
        preferredSize.width = (int)Math.floor((double)preferredSize.width / this.zoomFactor);
        preferredSize.height = (int)Math.floor((double)preferredSize.height / this.zoomFactor);
        return new Rectangle(preferredSize);
    }

    private void addComponent() {
        Scene scene = this.getScene();
        if (!this.componentAdded) {
            scene.getView().add(this.component);
            this.component.addComponentListener(this.componentListener);
            this.componentAdded = true;
        }
        this.component.removeComponentListener(this.componentListener);
        this.component.setBounds(scene.convertSceneToView(this.convertLocalToScene(this.getClientArea())));
        this.component.addComponentListener(this.componentListener);
        this.component.repaint();
    }

    private void removeComponent() {
        Scene scene = this.getScene();
        if (this.componentAdded) {
            this.component.removeComponentListener(this.componentListener);
            scene.getView().remove(this.component);
            this.componentAdded = false;
        }
    }

    protected final void paintWidget() {
        if (this.getScene().isPaintEverything() || !this.componentVisible) {
            Graphics2D graphics = this.getGraphics();
            Rectangle bounds = this.getClientArea();
            AffineTransform previousTransform = graphics.getTransform();
            graphics.translate(bounds.x, bounds.y);
            double zoomFactor = this.getScene().getZoomFactor();
            graphics.scale(1.0 / zoomFactor, 1.0 / zoomFactor);
            this.component.paint(graphics);
            graphics.setTransform(previousTransform);
        }
    }

    private final class ComponentComponentListener
    implements ComponentListener {
        private ComponentComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            ComponentWidget.this.revalidate();
        }

        public void componentMoved(ComponentEvent e) {
            ComponentWidget.this.revalidate();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }

    private final class ComponentSceneListener
    implements Scene.SceneListener {
        private ComponentSceneListener() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            double newZoomFactor = ComponentWidget.this.getScene().getZoomFactor();
            if (Math.abs(newZoomFactor - ComponentWidget.this.zoomFactor) != 0.0) {
                ComponentWidget.this.revalidate();
                ComponentWidget.this.zoomFactor = newZoomFactor;
            }
        }

        public void sceneValidated() {
            if (ComponentWidget.this.widgetAdded && ComponentWidget.this.componentVisible) {
                ComponentWidget.this.addComponent();
            } else {
                ComponentWidget.this.removeComponent();
                ComponentWidget.this.detach();
            }
        }
    }
}

