/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.ConnectionWidgetLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWidget
extends Widget {
    private static final double HIT_DISTANCE_SQUARE = 16.0;
    private static final Stroke STROKE_DEFAULT = new BasicStroke(1.0f);
    private Anchor sourceAnchor;
    private Anchor targetAnchor;
    private AnchorShape sourceAnchorShape;
    private AnchorShape targetAnchorShape;
    private PointShape controlPointShape;
    private PointShape endPointShape;
    private Router router;
    private boolean routingRequired = true;
    private List<Point> controlPoints = Collections.emptyList();
    private List<Point> controlPointsUm = Collections.unmodifiableList(this.controlPoints);
    private ConnectionWidgetLayout connectionWidgetLayout;
    private Stroke stroke;
    private boolean paintControlPoints;
    private Color lineColor;
    private Anchor.Entry sourceEntry;
    private Anchor.Entry targetEntry;

    public ConnectionWidget(Scene scene) {
        super(scene);
        this.sourceAnchorShape = AnchorShape.NONE;
        this.targetAnchorShape = AnchorShape.NONE;
        this.controlPointShape = PointShape.NONE;
        this.endPointShape = PointShape.NONE;
        this.router = RouterFactory.createDirectRouter();
        this.connectionWidgetLayout = new ConnectionWidgetLayout(this);
        this.setLayout(this.connectionWidgetLayout);
        this.stroke = STROKE_DEFAULT;
        this.paintControlPoints = false;
        this.sourceEntry = new ConnectionEntry(true);
        this.targetEntry = new ConnectionEntry(false);
    }

    @Override
    public void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.setForeground(this.lineColor != null ? this.lineColor : this.getScene().getLookFeel().getLineColor(state));
        this.setPaintControlPoints(state.isSelected());
    }

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(Stroke stroke) {
        assert (stroke != null);
        this.stroke = stroke;
        this.repaint();
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
        ObjectState state = this.getState();
        this.notifyStateChanged(state, state);
    }

    public final boolean isPaintControlPoints() {
        return this.paintControlPoints;
    }

    public final void setPaintControlPoints(boolean paintControlPoints) {
        this.paintControlPoints = paintControlPoints;
        this.repaint();
    }

    public final Anchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public final void setSourceAnchor(Anchor sourceAnchor) {
        if (this.sourceAnchor != null) {
            this.sourceAnchor.removeEntry(this.sourceEntry);
        }
        this.sourceAnchor = sourceAnchor;
        if (this.sourceAnchor != null) {
            sourceAnchor.addEntry(this.sourceEntry);
        }
        this.reroute();
    }

    public final Anchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public final void setTargetAnchor(Anchor targetAnchor) {
        if (this.targetAnchor != null) {
            this.targetAnchor.removeEntry(this.targetEntry);
        }
        this.targetAnchor = targetAnchor;
        if (targetAnchor != null) {
            targetAnchor.addEntry(this.targetEntry);
        }
        this.reroute();
    }

    public Anchor.Entry getSourceAnchorEntry() {
        return this.sourceEntry;
    }

    public Anchor.Entry getTargetAnchorEntry() {
        return this.targetEntry;
    }

    public AnchorShape getSourceAnchorShape() {
        return this.sourceAnchorShape;
    }

    public void setSourceAnchorShape(AnchorShape sourceAnchorShape) {
        assert (sourceAnchorShape != null);
        boolean repaintOnly = this.sourceAnchorShape.getRadius() == sourceAnchorShape.getRadius();
        this.sourceAnchorShape = sourceAnchorShape;
        this.revalidate(repaintOnly);
    }

    public AnchorShape getTargetAnchorShape() {
        return this.targetAnchorShape;
    }

    public void setTargetAnchorShape(AnchorShape targetAnchorShape) {
        assert (targetAnchorShape != null);
        boolean repaintOnly = this.targetAnchorShape.getRadius() == targetAnchorShape.getRadius();
        this.targetAnchorShape = targetAnchorShape;
        this.revalidate(repaintOnly);
    }

    public PointShape getControlPointShape() {
        return this.controlPointShape;
    }

    public void setControlPointShape(PointShape controlPointShape) {
        assert (controlPointShape != null);
        boolean repaintOnly = this.controlPointShape.getRadius() == controlPointShape.getRadius();
        this.controlPointShape = controlPointShape;
        this.revalidate(repaintOnly);
    }

    public PointShape getEndPointShape() {
        return this.endPointShape;
    }

    public void setEndPointShape(PointShape endPointShape) {
        assert (endPointShape != null);
        boolean repaintOnly = this.endPointShape.getRadius() == endPointShape.getRadius();
        this.endPointShape = endPointShape;
        this.revalidate(repaintOnly);
    }

    public final Router getRouter() {
        return this.router;
    }

    public final void setRouter(Router router) {
        this.router = router;
        this.reroute();
    }

    public List<Point> getControlPoints() {
        return this.controlPointsUm;
    }

    public Point getControlPoint(int index) {
        if (index < 0 && index >= this.controlPoints.size()) {
            return null;
        }
        return new Point(this.controlPoints.get(index));
    }

    public void setControlPoints(Collection<Point> controlPoints, boolean sceneLocations) {
        if (sceneLocations) {
            Point translation = this.convertLocalToScene(new Point());
            ArrayList<Point> list = new ArrayList<Point>();
            for (Point point : controlPoints) {
                list.add(new Point(point.x - translation.x, point.y - translation.y));
            }
            this.controlPoints = list;
        } else {
            this.controlPoints = new ArrayList<Point>(controlPoints);
        }
        this.controlPointsUm = Collections.unmodifiableList(this.controlPoints);
        this.routingRequired = false;
        this.revalidate();
    }

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, float placementInPercentage) {
        this.connectionWidgetLayout.setConstraint(childWidget, alignment, placementInPercentage);
    }

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, int placementAtDistance) {
        this.connectionWidgetLayout.setConstraint(childWidget, alignment, placementAtDistance);
    }

    public void removeConstraint(Widget childWidget) {
        this.connectionWidgetLayout.removeConstraint(childWidget);
    }

    public final void calculateRouting() {
        if (this.routingRequired) {
            this.setControlPoints(this.router.routeConnection(this), true);
        }
    }

    @Override
    protected Rectangle calculateClientArea() {
        Point lastPoint;
        this.calculateRouting();
        int controlPointShapeRadius = this.controlPointShape.getRadius();
        int controlPointShapeRadius2 = controlPointShapeRadius + controlPointShapeRadius;
        int endPointShapeRadius = this.endPointShape.getRadius();
        Rectangle rect = null;
        for (Point point : this.controlPoints) {
            Rectangle addRect = new Rectangle(point.x - controlPointShapeRadius, point.y - controlPointShapeRadius, controlPointShapeRadius2, controlPointShapeRadius2);
            if (rect == null) {
                rect = addRect;
                continue;
            }
            rect.add(addRect);
        }
        Point firstPoint = this.getFirstControlPoint();
        if (firstPoint != null) {
            int radius = Math.max(this.sourceAnchorShape.getRadius(), endPointShapeRadius);
            int radius2 = radius + radius;
            if (rect == null) {
                rect = new Rectangle(firstPoint.x - radius, firstPoint.y - radius, radius2, radius2);
            } else {
                rect.add(new Rectangle(firstPoint.x - radius, firstPoint.y - radius, radius2, radius2));
            }
        }
        if ((lastPoint = this.getLastControlPoint()) != null) {
            int radius = Math.max(this.targetAnchorShape.getRadius(), endPointShapeRadius);
            int radius2 = radius + radius;
            if (rect == null) {
                rect = new Rectangle(lastPoint.x - radius, lastPoint.y - radius, radius2, radius2);
            } else {
                rect.add(new Rectangle(lastPoint.x - radius, lastPoint.y - radius, radius2, radius2));
            }
        }
        if (rect != null) {
            rect.grow(2, 2);
        }
        return rect != null ? rect : new Rectangle();
    }

    @Override
    public boolean isValidated() {
        return super.isValidated() && this.isRouted();
    }

    public final boolean isRouted() {
        return !this.routingRequired;
    }

    public final void reroute() {
        this.routingRequired = true;
        this.revalidate();
    }

    public final Point getFirstControlPoint() {
        if (this.controlPoints.size() <= 0) {
            return null;
        }
        return new Point(this.controlPoints.get(0));
    }

    public final Point getLastControlPoint() {
        int size = this.controlPoints.size();
        if (size <= 0) {
            return null;
        }
        return new Point(this.controlPoints.get(size - 1));
    }

    private double getSourceAnchorShapeRotation() {
        if (this.controlPoints.size() <= 1) {
            return 0.0;
        }
        Point point1 = this.controlPoints.get(0);
        Point point2 = this.controlPoints.get(1);
        return Math.atan2(point2.y - point1.y, point2.x - point1.x);
    }

    public double getTargetAnchorShapeRotation() {
        int size = this.controlPoints.size();
        if (size <= 1) {
            return 0.0;
        }
        Point point1 = this.controlPoints.get(size - 1);
        Point point2 = this.controlPoints.get(size - 2);
        return Math.atan2(point2.y - point1.y, point2.x - point1.x);
    }

    @Override
    public boolean isHitAt(Point localLocation) {
        if (!super.isHitAt(localLocation)) {
            return false;
        }
        List<Point> controlPoints = this.getControlPoints();
        for (int i = 0; i < controlPoints.size() - 1; ++i) {
            Point point1 = controlPoints.get(i);
            Point point2 = controlPoints.get(i + 1);
            double dist = Line2D.ptSegDistSq(point1.x, point1.y, point2.x, point2.y, localLocation.x, localLocation.y);
            if (!(dist < 16.0)) continue;
            return true;
        }
        return this.getControlPointHitAt(localLocation) >= 0;
    }

    public final boolean isFirstControlPointHitAt(Point localLocation) {
        int endRadius = this.endPointShape.getRadius();
        endRadius *= endRadius;
        Point firstPoint = this.getFirstControlPoint();
        return firstPoint != null && Point2D.distanceSq(firstPoint.x, firstPoint.y, localLocation.x, localLocation.y) <= (double)endRadius;
    }

    public final boolean isLastControlPointHitAt(Point localLocation) {
        int endRadius = this.endPointShape.getRadius();
        endRadius *= endRadius;
        Point lastPoint = this.getLastControlPoint();
        return lastPoint != null && Point2D.distanceSq(lastPoint.x, lastPoint.y, localLocation.x, localLocation.y) <= (double)endRadius;
    }

    public final int getControlPointHitAt(Point localLocation) {
        int controlRadius = this.controlPointShape.getRadius();
        controlRadius *= controlRadius;
        if (this.isFirstControlPointHitAt(localLocation)) {
            return 0;
        }
        if (this.isLastControlPointHitAt(localLocation)) {
            return this.controlPoints.size() - 1;
        }
        for (int i = 0; i < this.controlPoints.size(); ++i) {
            Point point = this.controlPoints.get(i);
            if (!(Point2D.distanceSq(point.x, point.y, localLocation.x, localLocation.y) <= (double)controlRadius)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void paintWidget() {
        AffineTransform previousTransform;
        List<Point> points;
        double lastControlPointRotation;
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        GeneralPath path = null;
        Point firstControlPoint = this.getFirstControlPoint();
        Point lastControlPoint = this.getLastControlPoint();
        boolean isSourceCutDistance = Math.abs(this.sourceAnchorShape.getCutDistance()) != 0.0;
        boolean isTargetCutDistance = Math.abs(this.targetAnchorShape.getCutDistance()) != 0.0;
        double firstControlPointRotation = firstControlPoint != null && (this.sourceAnchorShape.isLineOriented() || isSourceCutDistance) ? this.getSourceAnchorShapeRotation() : 0.0;
        double d = lastControlPointRotation = lastControlPoint != null && (this.targetAnchorShape.isLineOriented() || isTargetCutDistance) ? this.getTargetAnchorShapeRotation() : 0.0;
        if ((isSourceCutDistance || isTargetCutDistance) && this.controlPoints.size() >= 2) {
            points = new ArrayList<Point>(this.controlPoints);
            points.set(0, new Point(firstControlPoint.x + (int)(this.sourceAnchorShape.getCutDistance() * Math.cos(firstControlPointRotation)), firstControlPoint.y + (int)(this.sourceAnchorShape.getCutDistance() * Math.sin(firstControlPointRotation))));
            points.set(this.controlPoints.size() - 1, new Point(lastControlPoint.x + (int)(this.targetAnchorShape.getCutDistance() * Math.cos(lastControlPointRotation)), lastControlPoint.y + (int)(this.targetAnchorShape.getCutDistance() * Math.sin(lastControlPointRotation))));
        } else {
            points = this.controlPoints;
        }
        for (Point point : points) {
            if (path == null) {
                path = new GeneralPath();
                path.moveTo(point.x, point.y);
                continue;
            }
            path.lineTo(point.x, point.y);
        }
        if (path != null) {
            Stroke previousStroke = gr.getStroke();
            gr.setPaint(this.getForeground());
            gr.setStroke(this.getStroke());
            gr.draw(path);
            gr.setStroke(previousStroke);
        }
        if (firstControlPoint != null) {
            previousTransform = gr.getTransform();
            gr.translate(firstControlPoint.x, firstControlPoint.y);
            if (this.sourceAnchorShape.isLineOriented()) {
                gr.rotate(firstControlPointRotation);
            }
            this.sourceAnchorShape.paint(gr, true);
            gr.setTransform(previousTransform);
        }
        if (lastControlPoint != null) {
            previousTransform = gr.getTransform();
            gr.translate(lastControlPoint.x, lastControlPoint.y);
            if (this.targetAnchorShape.isLineOriented()) {
                gr.rotate(lastControlPointRotation);
            }
            this.targetAnchorShape.paint(gr, false);
            gr.setTransform(previousTransform);
        }
        if (this.paintControlPoints) {
            int last = this.controlPoints.size() - 1;
            for (int index = 0; index <= last; ++index) {
                Point point = this.controlPoints.get(index);
                previousTransform = gr.getTransform();
                gr.translate(point.x, point.y);
                if (index == 0 || index == last) {
                    this.endPointShape.paint(gr);
                } else {
                    this.controlPointShape.paint(gr);
                }
                gr.setTransform(previousTransform);
            }
        }
    }

    private class ConnectionEntry
    implements Anchor.Entry {
        private boolean source;

        public ConnectionEntry(boolean source) {
            this.source = source;
        }

        public void revalidateEntry() {
            ConnectionWidget.this.reroute();
        }

        public ConnectionWidget getAttachedConnectionWidget() {
            return ConnectionWidget.this;
        }

        public boolean isAttachedToConnectionSource() {
            return this.source;
        }

        public Anchor getAttachedAnchor() {
            return this.source ? ConnectionWidget.this.getSourceAnchor() : ConnectionWidget.this.getTargetAnchor();
        }

        public Anchor getOppositeAnchor() {
            return this.source ? ConnectionWidget.this.getTargetAnchor() : ConnectionWidget.this.getSourceAnchor();
        }
    }
}

