/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public class LabelWidget
extends Widget {
    private String label;
    private Alignment alignment = Alignment.LEFT;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BASELINE;
    private boolean paintAsDisabled;

    public LabelWidget(Scene scene) {
        this(scene, null);
    }

    public LabelWidget(Scene scene, String label) {
        super(scene);
        this.setOpaque(false);
        this.setLabel(label);
        this.setCheckClipping(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (GeomUtil.equals(this.label, label)) {
            return;
        }
        this.label = label;
        this.revalidate();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.repaint();
    }

    public boolean isPaintAsDisabled() {
        return this.paintAsDisabled;
    }

    public void setPaintAsDisabled(boolean paintAsDisabled) {
        boolean repaint = this.paintAsDisabled != paintAsDisabled;
        this.paintAsDisabled = paintAsDisabled;
        if (repaint) {
            this.repaint();
        }
    }

    protected Rectangle calculateClientArea() {
        if (this.label == null) {
            return super.calculateClientArea();
        }
        Graphics2D gr = this.getGraphics();
        FontMetrics fontMetrics = gr.getFontMetrics(this.getFont());
        Rectangle2D stringBounds = fontMetrics.getStringBounds(this.label, gr);
        return GeomUtil.roundRectangle(stringBounds);
    }

    protected void paintWidget() {
        int y;
        int x;
        if (this.label == null) {
            return;
        }
        Graphics2D gr = this.getGraphics();
        gr.setFont(this.getFont());
        FontMetrics fontMetrics = gr.getFontMetrics();
        Rectangle clientArea = this.getClientArea();
        switch (this.alignment) {
            case BASELINE: {
                x = 0;
                break;
            }
            case LEFT: {
                x = clientArea.x;
                break;
            }
            case CENTER: {
                x = clientArea.x + (clientArea.width - fontMetrics.stringWidth(this.label)) / 2;
                break;
            }
            case RIGHT: {
                x = clientArea.x + clientArea.width - fontMetrics.stringWidth(this.label);
                break;
            }
            default: {
                return;
            }
        }
        switch (this.verticalAlignment) {
            case BASELINE: {
                y = 0;
                break;
            }
            case TOP: {
                y = clientArea.y + fontMetrics.getAscent();
                break;
            }
            case CENTER: {
                y = clientArea.y + (clientArea.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                break;
            }
            case BOTTOM: {
                y = clientArea.y + fontMetrics.getAscent() + clientArea.height - fontMetrics.getDescent();
                break;
            }
            default: {
                return;
            }
        }
        Paint background = this.getBackground();
        if (this.paintAsDisabled && background instanceof Color) {
            Color color = (Color)background;
            gr.setColor(color.brighter());
            gr.drawString(this.label, x + 1, y + 1);
            gr.setColor(color.darker());
            gr.drawString(this.label, x, y);
        } else {
            gr.setColor(this.getForeground());
            gr.drawString(this.label, x, y);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalAlignment {
        TOP,
        BOTTOM,
        CENTER,
        BASELINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        BASELINE;

    }
}

