/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

final class SceneComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener,
FocusListener,
DropTargetListener {
    private Scene scene;
    private Widget lockedWidget;
    private WidgetAction lockedAction;
    private long eventIDcounter = 0L;
    private AccessibleContext accessibleContext;

    public SceneComponent(Scene scene) {
        this.scene = scene;
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setDropTarget(new DropTarget(this, 3, this));
        this.setAutoscrolls(true);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public void addNotify() {
        super.addNotify();
        this.scene.setGraphics((Graphics2D)this.getGraphics());
        this.scene.revalidate();
        this.scene.setViewShowing(true);
        this.scene.validate();
    }

    public void removeNotify() {
        super.removeNotify();
        this.scene.setViewShowing(false);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    private void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle bounds = this.scene.getBounds();
        if (bounds != null && width == bounds.width && height == bounds.height) {
            return;
        }
        this.scene.revalidate();
        this.scene.validate();
    }

    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        Object props = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (props instanceof Map) {
            gr.addRenderingHints((Map)props);
        }
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.scene.setGraphics(gr);
        AffineTransform previousTransform = gr.getTransform();
        double zoomFactor = this.scene.getZoomFactor();
        gr.scale(zoomFactor, zoomFactor);
        this.scene.setPaintEverything(false);
        this.scene.paint();
        this.scene.setPaintEverything(true);
        gr.setTransform(previousTransform);
        g.setColor(Color.BLACK);
        super.paint(g);
    }

    public void focusGained(FocusEvent e) {
        this.processOperator(Operator.FOCUS_GAINED, new WidgetAction.WidgetFocusEvent(++this.eventIDcounter, e));
    }

    public void focusLost(FocusEvent e) {
        this.processOperator(Operator.FOCUS_LOST, new WidgetAction.WidgetFocusEvent(++this.eventIDcounter, e));
    }

    public void mouseClicked(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_CLICKED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mousePressed(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_PRESSED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseReleased(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_RELEASED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseEntered(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_ENTERED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseExited(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_EXITED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseDragged(MouseEvent e) {
        this.processLocationOperator(Operator.MOUSE_DRAGGED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseMoved(MouseEvent e) {
        MouseContext context = new MouseContext();
        Point point = this.scene.convertViewToScene(e.getPoint());
        this.resolveContext(this.scene, point, context);
        context.commit(this);
        this.processLocationOperator(Operator.MOUSE_MOVED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, e));
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.processLocationOperator(Operator.MOUSE_WHEEL, new WidgetAction.WidgetMouseWheelEvent(++this.eventIDcounter, e));
    }

    public void keyTyped(KeyEvent e) {
        WidgetAction.State state;
        if ((state = this.processKeyOperator(Operator.KEY_TYPED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        WidgetAction.State state;
        if ((state = this.processKeyOperator(Operator.KEY_PRESSED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
        WidgetAction.State state;
        if ((state = this.processKeyOperator(Operator.KEY_RELEASED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.consume();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DRAG_ENTER, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DRAG_OVER, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DROP_ACTION_CHANGED, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent e) {
        this.processOperator(Operator.DRAG_EXIT, new WidgetAction.WidgetDropTargetEvent(++this.eventIDcounter, e));
    }

    public void drop(DropTargetDropEvent e) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DROP, new WidgetAction.WidgetDropTargetDropEvent(++this.eventIDcounter, e))).isConsumed()) {
            e.rejectDrop();
        }
    }

    private WidgetAction.State processLocationOperator(Operator operator, WidgetAction.WidgetLocationEvent event) {
        WidgetAction.State state;
        Point location;
        event.setPoint(this.scene.convertViewToScene(event.getPoint()));
        String tool = this.scene.getActiveTool();
        WidgetAction.Chain priorActions = this.scene.getPriorActions();
        if (!priorActions.getActions().isEmpty()) {
            location = this.scene.getLocation();
            event.translatePoint(location.x, location.y);
            if (operator.operate(priorActions, this.scene, event).isConsumed()) {
                return WidgetAction.State.CONSUMED;
            }
            event.translatePoint(-location.x, -location.y);
        }
        if (this.lockedAction != null) {
            location = this.lockedWidget.convertSceneToLocal(new Point());
            event.translatePoint(location.x, location.y);
            state = operator.operate(this.lockedAction, this.lockedWidget, event);
            event.translatePoint(-location.x, -location.y);
            if (!state.isConsumed()) {
                location = this.scene.getLocation();
                event.translatePoint(location.x, location.y);
                state = this.processLocationOperator(operator, tool, this.scene, event);
            }
        } else {
            location = this.scene.getLocation();
            event.translatePoint(location.x, location.y);
            state = this.processLocationOperator(operator, tool, this.scene, event);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedWidget != null) {
            this.scrollRectToVisible(this.scene.convertSceneToView(this.lockedWidget.convertLocalToScene(this.lockedWidget.getBounds())));
        }
        return state;
    }

    private WidgetAction.State processLocationOperator(Operator operator, String tool, Widget widget, WidgetAction.WidgetLocationEvent event) {
        if (!widget.isVisible() || !widget.isEnabled()) {
            return WidgetAction.State.REJECTED;
        }
        Point location = widget.getLocation();
        event.translatePoint(-location.x, -location.y);
        Rectangle bounds = widget.getBounds();
        assert (bounds != null) : "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
        if (bounds.contains(event.getPoint())) {
            WidgetAction.State state;
            List<Widget> children = widget.getChildren();
            Widget[] childrenArray = children.toArray(new Widget[children.size()]);
            for (int i = childrenArray.length - 1; i >= 0; --i) {
                Widget child = childrenArray[i];
                state = this.processLocationOperator(operator, tool, child, event);
                if (!state.isConsumed()) continue;
                return state;
            }
            if (widget.isHitAt(event.getPoint())) {
                WidgetAction.Chain actions = widget.getActions();
                state = operator.operate(actions, widget, event);
                if (state.isConsumed()) {
                    return state;
                }
                actions = widget.getActions(tool);
                if (actions != null && (state = operator.operate(actions, widget, event)).isConsumed()) {
                    return state;
                }
            }
        }
        event.translatePoint(location.x, location.y);
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processOperator(Operator operator, WidgetAction.WidgetEvent event) {
        WidgetAction.State state;
        String tool = this.scene.getActiveTool();
        WidgetAction.Chain priorActions = this.scene.getPriorActions();
        if (!priorActions.getActions().isEmpty() && operator.operate(priorActions, this.scene, event).isConsumed()) {
            return WidgetAction.State.CONSUMED;
        }
        if (this.lockedAction != null) {
            state = operator.operate(this.lockedAction, this.lockedWidget, event);
            if (!state.isConsumed()) {
                state = this.processOperator(operator, tool, this.scene, event);
            }
        } else {
            state = this.processOperator(operator, tool, this.scene, event);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedWidget != null) {
            this.scrollRectToVisible(this.scene.convertSceneToView(this.lockedWidget.convertLocalToScene(this.lockedWidget.getBounds())));
        }
        return state;
    }

    private WidgetAction.State processOperator(Operator operator, String tool, Widget widget, WidgetAction.WidgetEvent event) {
        WidgetAction.State state;
        if (!widget.isVisible() || !widget.isEnabled()) {
            return WidgetAction.State.REJECTED;
        }
        List<Widget> children = widget.getChildren();
        Widget[] childrenArray = children.toArray(new Widget[children.size()]);
        for (int i = childrenArray.length - 1; i >= 0; --i) {
            Widget child = childrenArray[i];
            state = this.processOperator(operator, tool, child, event);
            if (!state.isConsumed()) continue;
            return state;
        }
        state = operator.operate(widget.getActions(), widget, event);
        if (state.isConsumed()) {
            return state;
        }
        WidgetAction.Chain actions = widget.getActions(tool);
        if (actions != null && (state = operator.operate(actions, widget, event)).isConsumed()) {
            return state;
        }
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processSingleOperator(Operator operator, String tool, Widget widget, WidgetAction.WidgetEvent event) {
        WidgetAction.State state = operator.operate(widget.getActions(), widget, event);
        if (state.isConsumed()) {
            return state;
        }
        WidgetAction.Chain actions = widget.getActions(tool);
        if (actions != null && (state = operator.operate(actions, widget, event)).isConsumed()) {
            return state;
        }
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processParentOperator(Operator operator, String tool, Widget widget, WidgetAction.WidgetKeyEvent event) {
        while (widget != null) {
            WidgetAction.State state = operator.operate(widget.getActions(), widget, event);
            if (state.isConsumed()) {
                return state;
            }
            WidgetAction.Chain actions = widget.getActions(tool);
            if (actions != null && (state = operator.operate(actions, widget, event)).isConsumed()) {
                return state;
            }
            widget = widget.getParentWidget();
        }
        return WidgetAction.State.REJECTED;
    }

    private Widget resolveTopMostDisabledWidget(Widget widget) {
        Widget disabledWidget = null;
        for (Widget tempWidget = widget; tempWidget != null; tempWidget = tempWidget.getParentWidget()) {
            if (tempWidget.isVisible() && tempWidget.isEnabled()) continue;
            disabledWidget = tempWidget;
        }
        return disabledWidget;
    }

    private WidgetAction.State processKeyOperator(Operator operator, WidgetAction.WidgetKeyEvent event) {
        WidgetAction.State state;
        String tool = this.scene.getActiveTool();
        WidgetAction.Chain priorActions = this.scene.getPriorActions();
        if (!priorActions.getActions().isEmpty() && operator.operate(priorActions, this.scene, event).isConsumed()) {
            return WidgetAction.State.CONSUMED;
        }
        if (this.lockedAction != null) {
            state = operator.operate(this.lockedAction, this.lockedWidget, event);
            if (!state.isConsumed()) {
                state = this.processKeyOperator(operator, tool, this.scene, event);
            }
        } else {
            state = this.processKeyOperator(operator, tool, this.scene, event);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedWidget != null) {
            this.scrollRectToVisible(this.scene.convertSceneToView(this.lockedWidget.convertLocalToScene(this.lockedWidget.getBounds())));
        }
        return state;
    }

    private WidgetAction.State processKeyOperator(Operator operator, String tool, Scene scene, WidgetAction.WidgetKeyEvent event) {
        Widget focusedWidget = scene.getFocusedWidget();
        switch (scene.getKeyEventProcessingType()) {
            case ALL_WIDGETS: {
                return this.processOperator(operator, tool, scene, event);
            }
            case FOCUSED_WIDGET_AND_ITS_PARENTS: {
                Widget disabledWidget = this.resolveTopMostDisabledWidget(focusedWidget);
                return this.processParentOperator(operator, tool, disabledWidget != null ? disabledWidget.getParentWidget() : focusedWidget, event);
            }
            case FOCUSED_WIDGET_AND_ITS_CHILDREN: {
                Widget disabledWidget = this.resolveTopMostDisabledWidget(focusedWidget);
                if (disabledWidget != null) {
                    return WidgetAction.State.REJECTED;
                }
                WidgetAction.State state = this.processSingleOperator(operator, tool, focusedWidget, event);
                if (state.isConsumed()) {
                    return state;
                }
                return this.processOperator(operator, tool, focusedWidget, event);
            }
            case FOCUSED_WIDGET_AND_ITS_CHILDREN_AND_ITS_PARENTS: {
                Widget disabledWidget = this.resolveTopMostDisabledWidget(focusedWidget);
                if (disabledWidget == null) {
                    WidgetAction.State state = this.processSingleOperator(operator, tool, focusedWidget, event);
                    if (state.isConsumed()) {
                        return state;
                    }
                    state = this.processOperator(operator, tool, focusedWidget, event);
                    if (state.isConsumed()) {
                        return state;
                    }
                }
                return this.processParentOperator(operator, tool, disabledWidget != null ? disabledWidget.getParentWidget() : focusedWidget.getParentWidget(), event);
            }
        }
        throw new IllegalStateException();
    }

    private boolean resolveContext(Widget widget, Point point, MouseContext context) {
        if (widget.getBounds().contains(point)) {
            List<Widget> children = widget.getChildren();
            for (int i = children.size() - 1; i >= 0; --i) {
                Widget child = children.get(i);
                Point location = child.getLocation();
                point.translate(-location.x, -location.y);
                boolean resolved = this.resolveContext(child, point, context);
                point.translate(location.x, location.y);
                if (!resolved) continue;
                return true;
            }
            if (widget.isHitAt(point)) {
                context.update(widget);
            }
        }
        return false;
    }

    private static final class MouseContext {
        private String toolTipText;
        private Cursor cursor;
        private AccessibleContext accessibleContext;

        private MouseContext() {
        }

        public boolean update(Widget widget) {
            if (this.cursor == null) {
                this.cursor = widget.getCursor();
            }
            if (this.toolTipText == null) {
                this.toolTipText = widget.getToolTipText();
            }
            if (this.accessibleContext == null) {
                this.accessibleContext = widget.getAccessibleContext();
            }
            return this.cursor == null || this.toolTipText == null || this.accessibleContext == null;
        }

        public void commit(SceneComponent component) {
            component.setToolTipText(this.toolTipText);
            component.setCursor(this.cursor);
            component.setAccessibleContext(this.accessibleContext);
        }
    }

    private static interface Operator {
        public static final Operator MOUSE_CLICKED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseClicked(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_PRESSED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mousePressed(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_RELEASED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseReleased(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_ENTERED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseEntered(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_EXITED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseExited(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_DRAGGED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseDragged(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_MOVED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseMoved(widget, (WidgetAction.WidgetMouseEvent)event);
            }
        };
        public static final Operator MOUSE_WHEEL = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.mouseWheelMoved(widget, (WidgetAction.WidgetMouseWheelEvent)event);
            }
        };
        public static final Operator KEY_TYPED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.keyTyped(widget, (WidgetAction.WidgetKeyEvent)event);
            }
        };
        public static final Operator KEY_PRESSED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.keyPressed(widget, (WidgetAction.WidgetKeyEvent)event);
            }
        };
        public static final Operator KEY_RELEASED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.keyReleased(widget, (WidgetAction.WidgetKeyEvent)event);
            }
        };
        public static final Operator FOCUS_GAINED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.focusGained(widget, (WidgetAction.WidgetFocusEvent)event);
            }
        };
        public static final Operator FOCUS_LOST = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.focusLost(widget, (WidgetAction.WidgetFocusEvent)event);
            }
        };
        public static final Operator DRAG_ENTER = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.dragEnter(widget, (WidgetAction.WidgetDropTargetDragEvent)event);
            }
        };
        public static final Operator DRAG_OVER = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.dragOver(widget, (WidgetAction.WidgetDropTargetDragEvent)event);
            }
        };
        public static final Operator DROP_ACTION_CHANGED = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.dropActionChanged(widget, (WidgetAction.WidgetDropTargetDragEvent)event);
            }
        };
        public static final Operator DRAG_EXIT = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.dragExit(widget, (WidgetAction.WidgetDropTargetEvent)event);
            }
        };
        public static final Operator DROP = new Operator(){

            public WidgetAction.State operate(WidgetAction action, Widget widget, WidgetAction.WidgetEvent event) {
                return action.drop(widget, (WidgetAction.WidgetDropTargetDropEvent)event);
            }
        };

        public WidgetAction.State operate(WidgetAction var1, Widget var2, WidgetAction.WidgetEvent var3);
    }
}

