/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemoveControlPointAction
extends WidgetAction.Adapter {
    private double createSensitivity = 1.0;
    private double deleteSensitivity = 5.0;
    private ConnectionWidget cWidget;

    public AddRemoveControlPointAction() {
    }

    public AddRemoveControlPointAction(double createSensitivity, double deleteSensitivity) {
        this.createSensitivity = createSensitivity;
        this.deleteSensitivity = deleteSensitivity;
    }

    @Override
    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 2 && widget instanceof ConnectionWidget) {
            this.cWidget = (ConnectionWidget)widget;
            Point point = event.getPoint();
            this.addRemoveControlPoint(point);
        }
        return WidgetAction.State.REJECTED;
    }

    private void addRemoveControlPoint(Point localLocation) {
        ArrayList<Point> list = new ArrayList<Point>(this.cWidget.getControlPoints());
        if (!this.removeControlPoint(localLocation, list, this.deleteSensitivity)) {
            Point exPoint = null;
            int index = 0;
            for (Point elem : list) {
                Line2D.Double l2d;
                if (exPoint != null && (l2d = new Line2D.Double(exPoint, elem)).ptLineDist(localLocation) < this.createSensitivity) {
                    list.add(index, localLocation);
                    break;
                }
                exPoint = elem;
                ++index;
            }
        }
        this.cWidget.setControlPoints(list, false);
    }

    private boolean removeControlPoint(Point point, ArrayList<Point> list, double deleteSensitivity) {
        for (Point elem : list) {
            if (!(elem.distance(point) < deleteSensitivity)) continue;
            list.remove(elem);
            return true;
        }
        return false;
    }

    private Point getControlPoint(int index) {
        List<Point> controlPoints = this.cWidget.getControlPoints();
        if (controlPoints.size() <= 0) {
            return null;
        }
        return new Point(controlPoints.get(index));
    }

    public void setSensitivity(double createSensitivity, double deleteSensitivity) {
        this.createSensitivity = createSensitivity;
        this.deleteSensitivity = deleteSensitivity;
    }
}

