/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public final class AlignWithMoveStrategyProvider
implements MoveStrategy,
MoveProvider {
    private static final int GRAVITY = 10;
    private AlignWithWidgetCollector collector;
    private LayerWidget interractionLayer;
    private AlignWithMoveDecorator decorator;
    private ConnectionWidget lineWidget1;
    private ConnectionWidget lineWidget2;

    public AlignWithMoveStrategyProvider(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator) {
        this.collector = collector;
        this.interractionLayer = interractionLayer;
        this.decorator = decorator;
    }

    public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
        int d;
        boolean snapNow;
        int a2;
        int a1;
        Point widgetLocation = widget.getLocation();
        Rectangle widgetBounds = widget.getBounds();
        Rectangle bounds = widget.convertLocalToScene(widgetBounds);
        bounds.translate(suggestedLocation.x - widgetLocation.x, suggestedLocation.y - widgetLocation.y);
        Point point = new Point(suggestedLocation);
        Collection<Rectangle> regions = this.collector.getRegions(widget);
        boolean snap = false;
        int xs = 0;
        int x = 0;
        int dx = 0;
        int y1 = 0;
        int y2 = 0;
        int b1 = bounds.x;
        int b2 = bounds.x + bounds.width;
        for (Rectangle rectangle : regions) {
            a1 = rectangle.x;
            a2 = a1 + rectangle.width;
            snapNow = false;
            d = Math.abs(a1 - b1);
            if (snap && d < dx || !snap && d < 10) {
                snapNow = true;
                snap = true;
                x = xs = a1;
                dx = d;
            }
            d = Math.abs(a1 - b2);
            if (snap && d < dx || !snap && d < 10) {
                snapNow = true;
                snap = true;
                x = a1;
                xs = a1 - widgetBounds.width;
                dx = d;
            }
            d = Math.abs(a2 - b1);
            if (snap && d < dx || !snap && d < 10) {
                snapNow = true;
                snap = true;
                x = xs = a2;
                dx = d;
            }
            d = Math.abs(a2 - b2);
            if (snap && d < dx || !snap && d < 10) {
                snapNow = true;
                snap = true;
                x = a2;
                xs = a2 - widgetBounds.width;
                dx = d;
            }
            if (!snapNow) continue;
            y1 = rectangle.y;
            y2 = rectangle.y + rectangle.height;
        }
        if (snap) {
            point.x = xs - widgetBounds.x;
        }
        if (this.interractionLayer != null) {
            this.lineWidget1.setControlPoints(snap ? Arrays.asList(new Point(x, Math.min(bounds.y, y1)), new Point(x, Math.max(bounds.y + bounds.height, y2))) : Collections.emptyList(), true);
        }
        snap = false;
        int ys = 0;
        int y = 0;
        int dy = 0;
        int x1 = 0;
        int x2 = 0;
        b1 = bounds.y;
        b2 = bounds.y + bounds.height;
        for (Rectangle rectangle : regions) {
            a1 = rectangle.y;
            a2 = a1 + rectangle.height;
            snapNow = false;
            d = Math.abs(a1 - b1);
            if (snap && d < dy || !snap && d < 10) {
                snapNow = true;
                snap = true;
                y = ys = a1;
                dy = d;
            }
            d = Math.abs(a1 - b2);
            if (snap && d < dy || !snap && d < 10) {
                snapNow = true;
                snap = true;
                ys = a1 - widgetBounds.height;
                y = a1;
                dy = d;
            }
            d = Math.abs(a2 - b1);
            if (snap && d < dy || !snap && d < 10) {
                snapNow = true;
                snap = true;
                y = ys = a2;
                dy = d;
            }
            d = Math.abs(a2 - b2);
            if (snap && d < dy || !snap && d < 10) {
                snapNow = true;
                snap = true;
                ys = a2 - widgetBounds.height;
                y = a2;
                dy = d;
            }
            if (!snapNow) continue;
            x1 = rectangle.x;
            x2 = rectangle.x + rectangle.width;
        }
        if (snap) {
            point.y = ys - widgetBounds.y;
        }
        if (this.interractionLayer != null) {
            this.lineWidget2.setControlPoints(snap ? Arrays.asList(new Point(Math.min(bounds.x, x1), y), new Point(Math.max(bounds.x + bounds.width, x2), y)) : Collections.emptyList(), true);
        }
        return point;
    }

    public void movementStarted(Widget widget) {
        if (this.interractionLayer != null) {
            if (this.lineWidget1 == null) {
                this.lineWidget1 = this.decorator.createLineWidget(this.interractionLayer.getScene());
            }
            if (this.lineWidget2 == null) {
                this.lineWidget2 = this.decorator.createLineWidget(this.interractionLayer.getScene());
            }
            this.interractionLayer.addChild(this.lineWidget1);
            this.interractionLayer.addChild(this.lineWidget2);
            this.lineWidget1.setControlPoints(Collections.<Point>emptySet(), true);
            this.lineWidget2.setControlPoints(Collections.<Point>emptySet(), true);
        }
    }

    public void movementFinished(Widget widget) {
        if (this.interractionLayer != null) {
            this.interractionLayer.removeChild(this.lineWidget1);
            this.interractionLayer.removeChild(this.lineWidget2);
        }
    }

    public Point getOriginalLocation(Widget widget) {
        return ActionFactory.createDefaultMoveProvider().getOriginalLocation(widget);
    }

    public void setNewLocation(Widget widget, Point location) {
        ActionFactory.createDefaultMoveProvider().setNewLocation(widget, location);
    }
}

