/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class CenteredZoomAction
extends WidgetAction.Adapter {
    private double zoomMultiplier;

    public CenteredZoomAction(double zoomMultiplier) {
        this.zoomMultiplier = zoomMultiplier;
    }

    public WidgetAction.State mouseWheelMoved(Widget widget, WidgetAction.WidgetMouseWheelEvent event) {
        int amount;
        Scene scene = widget.getScene();
        double scale = 1.0;
        for (amount = event.getWheelRotation(); amount > 0; --amount) {
            scale /= this.zoomMultiplier;
        }
        while (amount < 0) {
            scale *= this.zoomMultiplier;
            ++amount;
        }
        JComponent view = scene.getView();
        if (view != null) {
            Rectangle viewBounds = view.getVisibleRect();
            Point center = GeomUtil.center(viewBounds);
            center = scene.convertViewToScene(center);
            scene.setZoomFactor(scale * scene.getZoomFactor());
            scene.validate();
            center = scene.convertSceneToView(center);
            view.scrollRectToVisible(new Rectangle(center.x - viewBounds.width / 2, center.y - viewBounds.height / 2, viewBounds.width, viewBounds.height));
        } else {
            scene.setZoomFactor(scale * scene.getZoomFactor());
        }
        return WidgetAction.State.CONSUMED;
    }
}

