/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class MoveControlPointAction
extends WidgetAction.LockedAdapter {
    private MoveControlPointProvider provider;
    private ConnectionWidget movingWidget = null;
    private Point controlPointLocation;
    private int controlPointIndex;
    private Point lastLocation = null;

    public MoveControlPointAction(MoveControlPointProvider provider) {
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1 && widget instanceof ConnectionWidget) {
            ConnectionWidget conn = (ConnectionWidget)widget;
            this.controlPointIndex = conn.getControlPointHitAt(event.getPoint());
            if (this.controlPointIndex >= 0) {
                this.movingWidget = conn;
                this.controlPointLocation = new Point(conn.getControlPoints().get(this.controlPointIndex));
                this.lastLocation = new Point(event.getPoint());
                return WidgetAction.State.createLocked(widget, this);
            }
            this.movingWidget = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        WidgetAction.State state = this.move(widget, event.getPoint());
        if (state.isConsumed()) {
            this.movingWidget = null;
        }
        return state;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint());
    }

    private WidgetAction.State move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return WidgetAction.State.REJECTED;
        }
        List<Point> controlPoints = this.movingWidget.getControlPoints();
        if (this.controlPointIndex < 0 || this.controlPointIndex >= controlPoints.size()) {
            return WidgetAction.State.REJECTED;
        }
        Point location = new Point(this.controlPointLocation);
        location.translate(newLocation.x - this.lastLocation.x, newLocation.y - this.lastLocation.y);
        controlPoints = this.provider.locationSuggested(this.movingWidget, this.controlPointIndex, location);
        if (controlPoints == null) {
            return WidgetAction.State.REJECTED;
        }
        this.movingWidget.setControlPoints(controlPoints, false);
        return WidgetAction.State.createLocked(widget, this);
    }
}

