/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Container;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class PanAction
extends WidgetAction.LockedAdapter {
    private Scene scene;
    private JScrollPane scrollPane;
    private Point lastLocation;

    protected boolean isLocked() {
        return this.scrollPane != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 2) {
            this.scene = widget.getScene();
            this.scrollPane = this.findScrollPane(this.scene.getView());
            if (this.scrollPane != null) {
                this.lastLocation = this.scene.convertSceneToView(widget.convertLocalToScene(event.getPoint()));
                SwingUtilities.convertPointToScreen(this.lastLocation, this.scene.getView());
                return WidgetAction.State.createLocked(widget, this);
            }
        }
        return WidgetAction.State.REJECTED;
    }

    private JScrollPane findScrollPane(JComponent component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return null;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.pan(widget, event.getPoint());
        if (state) {
            this.scrollPane = null;
        }
        return state ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.pan(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean pan(Widget widget, Point newLocation) {
        if (this.scrollPane == null || this.scene != widget.getScene()) {
            return false;
        }
        newLocation = this.scene.convertSceneToView(widget.convertLocalToScene(newLocation));
        SwingUtilities.convertPointToScreen(newLocation, this.scene.getView());
        Point viewPosition = this.scrollPane.getViewport().getViewPosition();
        viewPosition = new Point(viewPosition.x + this.lastLocation.x - newLocation.x, viewPosition.y + this.lastLocation.y - newLocation.y);
        this.scrollPane.getViewport().setViewPosition(viewPosition);
        this.lastLocation = newLocation;
        return true;
    }
}

