/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.ReconnectDecorator;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class ReconnectAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private ReconnectDecorator decorator;
    private ReconnectProvider provider;
    private ConnectionWidget connectionWidget = null;
    private boolean reconnectingSource = false;
    private Point floatPoint = null;
    private Widget replacementWidget = null;
    private Anchor originalAnchor = null;

    public ReconnectAction(ReconnectDecorator decorator, ReconnectProvider provider) {
        this.decorator = decorator;
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.connectionWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1 && widget instanceof ConnectionWidget) {
            ConnectionWidget conn = (ConnectionWidget)widget;
            int index = conn.getControlPointHitAt(event.getPoint());
            List<Point> controlPoints = conn.getControlPoints();
            if (index == 0 && this.provider.isSourceReconnectable(conn)) {
                this.reconnectingSource = true;
            } else if (controlPoints != null && index == controlPoints.size() - 1 && this.provider.isTargetReconnectable(conn)) {
                this.reconnectingSource = false;
            } else {
                return WidgetAction.State.REJECTED;
            }
            this.floatPoint = new Point(event.getPoint());
            this.replacementWidget = null;
            this.connectionWidget = conn;
            this.provider.reconnectingStarted(conn, this.reconnectingSource);
            this.originalAnchor = this.reconnectingSource ? this.connectionWidget.getSourceAnchor() : this.connectionWidget.getTargetAnchor();
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        Point point = event.getPoint();
        boolean state = this.move(widget, point);
        if (state) {
            if (this.reconnectingSource) {
                this.connectionWidget.setSourceAnchor(this.originalAnchor);
            } else {
                this.connectionWidget.setTargetAnchor(this.originalAnchor);
            }
            this.provider.reconnectingFinished(this.connectionWidget, this.reconnectingSource);
            if (Math.abs(this.floatPoint.x - point.x) >= 5 || Math.abs(this.floatPoint.y - point.y) >= 5) {
                this.provider.reconnect(this.connectionWidget, this.replacementWidget, this.reconnectingSource);
            }
            this.replacementWidget = null;
            this.floatPoint = null;
            this.connectionWidget = null;
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point point) {
        if (this.connectionWidget != widget) {
            return false;
        }
        Point replacementSceneLocation = widget.convertLocalToScene(point);
        this.replacementWidget = this.resolveReplacementWidgetCore(this.connectionWidget.getScene(), replacementSceneLocation);
        Anchor replacementAnchor = null;
        if (this.replacementWidget != null) {
            replacementAnchor = this.decorator.createReplacementWidgetAnchor(this.replacementWidget);
        }
        if (replacementAnchor == null) {
            replacementAnchor = this.decorator.createFloatAnchor(replacementSceneLocation);
        }
        if (this.reconnectingSource) {
            this.connectionWidget.setSourceAnchor(replacementAnchor);
        } else {
            this.connectionWidget.setTargetAnchor(replacementAnchor);
        }
        return true;
    }

    protected Widget resolveReplacementWidgetCore(Scene scene, Point sceneLocation) {
        if (this.provider != null && this.provider.hasCustomReplacementWidgetResolver(scene)) {
            return this.provider.resolveReplacementWidget(scene, sceneLocation);
        }
        Point sceneOrigin = scene.getLocation();
        sceneLocation = new Point(sceneLocation.x + sceneOrigin.x, sceneLocation.y + sceneOrigin.y);
        Widget[] result = new Widget[]{null};
        this.resolveReplacementWidgetCoreDive(result, scene, sceneLocation);
        return result[0];
    }

    private boolean resolveReplacementWidgetCoreDive(Widget[] result, Widget widget, Point parentLocation) {
        if (widget == this.connectionWidget) {
            return false;
        }
        Point widgetLocation = widget.getLocation();
        Point location = new Point(parentLocation.x - widgetLocation.x, parentLocation.y - widgetLocation.y);
        if (!widget.getBounds().contains(location)) {
            return false;
        }
        List<Widget> children = widget.getChildren();
        for (int i = children.size() - 1; i >= 0; --i) {
            if (!this.resolveReplacementWidgetCoreDive(result, children.get(i), location)) continue;
            return true;
        }
        if (!widget.isHitAt(location)) {
            return false;
        }
        ConnectorState state = this.provider.isReplacementWidget(this.connectionWidget, widget, this.reconnectingSource);
        if (state == ConnectorState.REJECT) {
            return false;
        }
        if (state == ConnectorState.ACCEPT) {
            result[0] = widget;
        }
        return true;
    }
}

