/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public final class RectangularSelectAction
extends WidgetAction.LockedAdapter {
    private RectangularSelectDecorator decorator;
    private LayerWidget interractionLayer;
    private RectangularSelectProvider provider;
    private Widget selectionWidget;
    private Rectangle selectionSceneRectangle;

    public RectangularSelectAction(RectangularSelectDecorator decorator, LayerWidget interractionLayer, RectangularSelectProvider provider) {
        this.decorator = decorator;
        this.interractionLayer = interractionLayer;
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.selectionSceneRectangle != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.selectionWidget = this.decorator.createSelectionWidget();
            assert (this.selectionWidget != null);
            this.interractionLayer.addChild(this.selectionWidget);
            this.selectionSceneRectangle = new Rectangle(widget.convertLocalToScene(event.getPoint()));
            this.move(widget, event.getPoint());
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.selectionSceneRectangle != null) {
            this.move(widget, event.getPoint());
            this.selectionWidget.getParentWidget().removeChild(this.selectionWidget);
            this.provider.performSelection(this.selectionSceneRectangle);
            this.selectionSceneRectangle = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.selectionSceneRectangle != null) {
            this.move(widget, event.getPoint());
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    private void resolveSelectionWidgetLocationBounds() {
        this.selectionWidget.setPreferredLocation(this.selectionSceneRectangle.getLocation());
        int w = this.selectionSceneRectangle.width;
        int h = this.selectionSceneRectangle.height;
        this.selectionWidget.setPreferredBounds(new Rectangle(w >= 0 ? 0 : w, h >= 0 ? 0 : h, w >= 0 ? w : -w, h >= 0 ? h : -h));
    }

    private void move(Widget widget, Point newLocation) {
        Point sceneLocation = widget.convertLocalToScene(newLocation);
        this.selectionSceneRectangle.width = sceneLocation.x - this.selectionSceneRectangle.x;
        this.selectionSceneRectangle.height = sceneLocation.y - this.selectionSceneRectangle.y;
        this.resolveSelectionWidgetLocationBounds();
    }
}

