/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class SelectAction
extends WidgetAction.LockedAdapter {
    private boolean aiming = false;
    private Widget aimedWidget = null;
    private boolean invertSelection;
    private SelectProvider provider;

    public SelectAction(SelectProvider provider) {
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.aiming;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 || event.getButton() == 2) {
            this.invertSelection = (event.getModifiersEx() & 0x80) != 0;
            Point localLocation = event.getPoint();
            if (this.provider.isSelectionAllowed(widget, localLocation, this.invertSelection)) {
                this.aiming = this.provider.isAimingAllowed(widget, localLocation, this.invertSelection);
                if (this.aiming) {
                    this.updateState(widget, localLocation);
                    return WidgetAction.State.createLocked(widget, this);
                }
                this.provider.select(widget, localLocation, this.invertSelection);
                return WidgetAction.State.CHAIN_ONLY;
            }
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.aiming) {
            Point point = event.getPoint();
            this.updateState(widget, point);
            if (this.aimedWidget != null) {
                this.provider.select(widget, point, this.invertSelection);
            }
            this.updateState(null, null);
            this.aiming = false;
            return WidgetAction.State.CONSUMED;
        }
        return super.mouseReleased(widget, event);
    }

    private void updateState(Widget widget, Point localLocation) {
        if (widget != null && !widget.isHitAt(localLocation)) {
            widget = null;
        }
        if (widget == this.aimedWidget) {
            return;
        }
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(false));
        }
        this.aimedWidget = widget;
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(true));
        }
    }

    public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (!this.aiming && event.getKeyChar() == ' ') {
            this.provider.select(widget, null, (event.getModifiersEx() & 0x80) != 0);
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

