/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class PreferredLocationAnimator
extends Animator {
    private HashMap<Widget, Point> sourceLocations = new HashMap();
    private HashMap<Widget, Point> targetLocations = new HashMap();

    public PreferredLocationAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setPreferredLocation(Widget widget, Point preferredLocation) {
        assert (widget != null);
        assert (preferredLocation != null);
        this.sourceLocations.clear();
        this.targetLocations.put(widget, preferredLocation);
        this.start();
    }

    protected void tick(double progress) {
        for (Map.Entry<Widget, Point> entry : this.targetLocations.entrySet()) {
            Point targetLocation;
            Widget widget = entry.getKey();
            Point sourceLocation = this.sourceLocations.get(widget);
            if (sourceLocation == null) {
                sourceLocation = widget.getPreferredLocation();
                if (sourceLocation == null && (sourceLocation = widget.getLocation()) == null) {
                    sourceLocation = new Point();
                }
                this.sourceLocations.put(widget, sourceLocation);
            }
            if ((targetLocation = entry.getValue()) == null) continue;
            Point point = progress >= 1.0 ? targetLocation : new Point((int)((double)sourceLocation.x + progress * (double)(targetLocation.x - sourceLocation.x)), (int)((double)sourceLocation.y + progress * (double)(targetLocation.y - sourceLocation.y)));
            widget.setPreferredLocation(point);
        }
        if (progress >= 1.0) {
            this.sourceLocations.clear();
            this.targetLocations.clear();
        }
    }
}

