/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public final class BevelBorder
implements Border {
    private boolean raised;
    private Color color;

    public BevelBorder(boolean raised, Color color) {
        this.raised = raised;
        this.color = color;
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public void paint(Graphics2D gr, Rectangle bounds) {
        gr.setColor(this.color);
        int h = bounds.height;
        int w = bounds.width;
        gr.translate(bounds.x, bounds.y);
        gr.setColor(this.raised ? this.color.brighter().brighter() : this.color.darker().darker());
        gr.drawLine(0, 0, 0, h - 2);
        gr.drawLine(1, 0, w - 2, 0);
        gr.setColor(this.raised ? this.color.brighter() : this.color.darker());
        gr.drawLine(1, 1, 1, h - 3);
        gr.drawLine(2, 1, w - 3, 1);
        gr.setColor(this.raised ? this.color.darker().darker() : this.color.brighter().brighter());
        gr.drawLine(0, h - 1, w - 1, h - 1);
        gr.drawLine(w - 1, 0, w - 1, h - 2);
        gr.setColor(this.raised ? this.color.darker() : this.color.brighter());
        gr.drawLine(1, h - 2, w - 2, h - 2);
        gr.drawLine(w - 2, 1, w - 2, h - 3);
        gr.translate(-bounds.x, -bounds.y);
    }

    public boolean isOpaque() {
        return true;
    }
}

