/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.netbeans.modules.visual.border.DashedBorder;

public final class FancyDashedBorder
extends DashedBorder {
    private static int focusField = 5;
    private static int rectSize = 5;
    private static int halfRectSize = rectSize / 2;
    private static int rect15Size = rectSize + halfRectSize;

    public FancyDashedBorder(Color color, int width, int height) {
        super(color, width, (float)height);
    }

    public void paint(Graphics2D g, Rectangle bounds) {
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        bounds.x += focusField / 2;
        bounds.y += focusField / 2;
        bounds.width -= focusField;
        bounds.height -= focusField;
        super.paint(g, bounds);
        g.drawRect(x, y, rectSize, rectSize);
        g.drawRect(x + width / 2 - halfRectSize, y, rectSize, rectSize);
        g.drawRect(x + width - rect15Size, y, rectSize, rectSize);
        g.drawRect(x + width - rect15Size, y - halfRectSize + height / 2, rectSize, rectSize);
        g.drawRect(x + width - rect15Size, y - rect15Size + height, rectSize, rectSize);
        g.drawRect(x + width / 2 - halfRectSize, y - rect15Size + height, rectSize, rectSize);
        g.drawRect(x, y - rect15Size + height, rectSize, rectSize);
        g.drawRect(x, y - rectSize + height / 2, rectSize, rectSize);
    }
}

