/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.border.Border;
import org.netbeans.modules.visual.util.GeomUtil;

public final class ResizeBorder
implements Border {
    private static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 5.0f, new float[]{6.0f, 3.0f}, 0.0f);
    private int thickness;
    private Color color;
    private boolean outer;

    public ResizeBorder(int thickness, Color color, boolean outer) {
        this.thickness = thickness;
        this.color = color;
        this.outer = outer;
    }

    public Insets getInsets() {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public void paint(Graphics2D gr, Rectangle bounds) {
        gr.setColor(this.color);
        Stroke stroke = gr.getStroke();
        gr.setStroke(STROKE);
        if (this.outer) {
            gr.draw(new Rectangle2D.Double((double)bounds.x + 0.5, (double)bounds.y + 0.5, (double)bounds.width - 1.0, (double)bounds.height - 1.0));
        } else {
            gr.draw(new Rectangle2D.Double((double)(bounds.x + this.thickness) + 0.5, (double)(bounds.y + this.thickness) + 0.5, (double)(bounds.width - this.thickness - this.thickness) - 1.0, (double)(bounds.height - this.thickness - this.thickness) - 1.0));
        }
        gr.setStroke(stroke);
        gr.fillRect(bounds.x, bounds.y, this.thickness, this.thickness);
        gr.fillRect(bounds.x + bounds.width - this.thickness, bounds.y, this.thickness, this.thickness);
        gr.fillRect(bounds.x, bounds.y + bounds.height - this.thickness, this.thickness, this.thickness);
        gr.fillRect(bounds.x + bounds.width - this.thickness, bounds.y + bounds.height - this.thickness, this.thickness, this.thickness);
        Point center = GeomUtil.center(bounds);
        if (bounds.width >= this.thickness * 5) {
            gr.fillRect(center.x - this.thickness / 2, bounds.y, this.thickness, this.thickness);
            gr.fillRect(center.x - this.thickness / 2, bounds.y + bounds.height - this.thickness, this.thickness, this.thickness);
        }
        if (bounds.height >= this.thickness * 5) {
            gr.fillRect(bounds.x, center.y - this.thickness / 2, this.thickness, this.thickness);
            gr.fillRect(bounds.x + bounds.width - this.thickness, center.y - this.thickness / 2, this.thickness, this.thickness);
        }
    }

    public boolean isOpaque() {
        return this.outer;
    }
}

