/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;

public final class RoundedBorder
implements Border {
    private int arcWidth;
    private int arcHeight;
    private int insetWidth;
    private int insetHeight;
    private Color fillColor;
    private Color drawColor;

    public RoundedBorder(int arcWidth, int arcHeight, int insetWidth, int insetHeight, Color fillColor, Color drawColor) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.insetWidth = insetWidth;
        this.insetHeight = insetHeight;
        this.fillColor = fillColor;
        this.drawColor = drawColor;
    }

    public Insets getInsets() {
        return new Insets(this.insetHeight, this.insetWidth, this.insetHeight, this.insetWidth);
    }

    public void paint(Graphics2D gr, Rectangle bounds) {
        if (this.fillColor != null) {
            gr.setColor(this.fillColor);
            gr.fill(new RoundRectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height, this.arcWidth, this.arcHeight));
        }
        if (this.drawColor != null) {
            gr.setColor(this.drawColor);
            gr.draw(new RoundRectangle2D.Float((float)bounds.x + 0.5f, (float)bounds.y + 0.5f, bounds.width - 1, bounds.height - 1, this.arcWidth, this.arcHeight));
        }
    }

    public boolean isOpaque() {
        return false;
    }
}

