/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.Widget;

public class FillLayout
implements Layout {
    public void layout(Widget widget) {
        Dimension total = new Dimension();
        for (Widget child : widget.getChildren()) {
            if (!child.isVisible()) continue;
            Dimension size = child.getPreferredBounds().getSize();
            if (size.width > total.width) {
                total.width = size.width;
            }
            if (size.height <= total.height) continue;
            total.height = size.height;
        }
        for (Widget child : widget.getChildren()) {
            Point location = child.getPreferredBounds().getLocation();
            child.resolveBounds(new Point(-location.x, -location.y), new Rectangle(location, total));
        }
    }

    public boolean requiresJustification(Widget widget) {
        return true;
    }

    public void justify(Widget widget) {
        Rectangle clientArea = widget.getClientArea();
        for (Widget child : widget.getChildren()) {
            if (child.isVisible()) {
                Point location = child.getPreferredBounds().getLocation();
                child.resolveBounds(new Point(clientArea.x - location.x, clientArea.y - location.y), new Rectangle(location, clientArea.getSize()));
                continue;
            }
            child.resolveBounds(clientArea.getLocation(), new Rectangle());
        }
    }
}

