/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public final class SerialLayout
implements Layout {
    private boolean verticalOrientation;
    private LayoutFactory.SerialAlignment alignment;
    private int gap;

    public SerialLayout(boolean verticalOrientation, LayoutFactory.SerialAlignment alignment, int gap) {
        this.verticalOrientation = verticalOrientation;
        this.alignment = alignment;
        this.gap = gap;
    }

    public void layout(Widget widget) {
        int max = 0;
        List<Widget> children = widget.getChildren();
        if (this.verticalOrientation) {
            for (Widget child : children) {
                if (!child.isVisible()) continue;
                Rectangle preferredBounds = child.getPreferredBounds();
                int i = preferredBounds.width;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = -x;
                int ly = pos - y;
                switch (this.alignment) {
                    case CENTER: {
                        lx += (max - width) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        width = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        lx += max - width;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += height + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        } else {
            for (Widget child : children) {
                if (!child.isVisible()) continue;
                Rectangle preferredBounds = child.getPreferredBounds();
                int i = preferredBounds.height;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = pos - x;
                int ly = -y;
                switch (this.alignment) {
                    case CENTER: {
                        ly += (max - height) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        height = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        ly += max - height;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += width + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        }
    }

    public boolean requiresJustification(Widget widget) {
        return this.alignment == LayoutFactory.SerialAlignment.JUSTIFY;
    }

    public void justify(Widget widget) {
        if (this.alignment != LayoutFactory.SerialAlignment.JUSTIFY) {
            return;
        }
        for (Widget child : widget.getChildren()) {
            Rectangle bounds = widget.getClientArea();
            Point location = child.getLocation();
            Rectangle childBounds = child.getBounds();
            if (this.verticalOrientation) {
                int parentX1 = bounds.x;
                int parentX2 = parentX1 + bounds.width;
                int childX1 = location.x + childBounds.x;
                int childX2 = childX1 + childBounds.width;
                childBounds.x = Math.min(parentX1, childX1);
                childBounds.width = Math.max(parentX2, childX2) - childBounds.x;
                childBounds.x -= location.x;
            } else {
                int parentY1 = bounds.y;
                int parentY2 = parentY1 + bounds.height;
                int childY1 = location.y + childBounds.y;
                int childY2 = childY1 + childBounds.height;
                childBounds.y = Math.min(parentY1, childY1);
                childBounds.height = Math.max(parentY2, childY2) - childBounds.y;
                childBounds.y -= location.y;
            }
            child.resolveBounds(location, childBounds);
        }
    }
}

