/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.modules.visual.router.OrthogonalSearchRouterCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalSearchRouter
implements Router {
    static final int SPACING_EDGE = 8;
    static final int SPACING_NODE = 16;
    private CollisionsCollector collector;

    public OrthogonalSearchRouter(CollisionsCollector collector) {
        this.collector = collector;
    }

    @Override
    public List<Point> routeConnection(ConnectionWidget widget) {
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null || targetAnchor == null) {
            return Collections.emptyList();
        }
        ArrayList<Rectangle> verticalCollisions = new ArrayList<Rectangle>();
        ArrayList<Rectangle> horizontalCollisions = new ArrayList<Rectangle>();
        this.collector.collectCollisions(verticalCollisions, horizontalCollisions);
        Anchor.Result sourceResult = sourceAnchor.compute(widget.getSourceAnchorEntry());
        Anchor.Result targetResult = targetAnchor.compute(widget.getTargetAnchorEntry());
        Point sourcePoint = sourceResult.getAnchorSceneLocation();
        Point targetPoint = targetResult.getAnchorSceneLocation();
        Solution bestSolution = new Solution(0x1FFFFFFF, Arrays.asList(sourcePoint, targetPoint));
        for (Anchor.Direction sourceDirection : sourceResult.getDirections()) {
            for (Anchor.Direction targetDirection : targetResult.getDirections()) {
                Solution solution = new OrthogonalSearchRouterCore(widget.getScene(), verticalCollisions, horizontalCollisions, sourcePoint, sourceDirection, targetPoint, targetDirection).route();
                if (solution == null || solution.compareTo(bestSolution) <= 0) continue;
                bestSolution = solution;
            }
        }
        return bestSolution.getPoints();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Solution
    implements Comparable<Solution> {
        private int price;
        private List<Point> points;

        public Solution(int price, List<Point> points) {
            this.price = price;
            this.points = points;
        }

        public int getPrice() {
            return this.price;
        }

        public List<Point> getPoints() {
            return this.points;
        }

        @Override
        public int compareTo(Solution other) {
            return other.price - this.price;
        }
    }
}

