/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.router.OrthogonalSearchRouter;
import org.netbeans.modules.visual.router.OrthogonalSearchRouterRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OrthogonalSearchRouterCore {
    private static final int MAXIMAL_DEPTH = 5;
    private static final int CORNER_LENGTH = 200;
    private static final boolean UPDATE_COLLISION_LISTS = true;
    private static final boolean UPDATE_COLLISION_LISTS_REMOVE = true;
    static final boolean IGNORE_LINKS_WITH_ACTUAL_PORTS = false;
    private static final boolean OPTIMALIZE_REGIONS = false;
    private Scene scene;
    private ArrayList<Rectangle> verticalCollisions;
    private ArrayList<Rectangle> horizontalCollisions;
    private Point sourcePoint;
    private Anchor.Direction sourceDirection;
    private Point targetPoint;
    private Anchor.Direction targetDirection;
    private Point sourceBoundaryPoint;
    private Point targetBoundaryPoint;
    private final OrthogonalSearchRouterRegion[] regions = new OrthogonalSearchRouterRegion[6];
    private Point[] bestControlPoints;
    private int bestControlPointsPrice;

    public OrthogonalSearchRouterCore(Scene scene, ArrayList<Rectangle> verticalCollisions, ArrayList<Rectangle> horizontalCollisions, Point sourcePoint, Anchor.Direction sourceDirection, Point targetPoint, Anchor.Direction targetDirection) {
        this.scene = scene;
        this.verticalCollisions = verticalCollisions;
        this.horizontalCollisions = horizontalCollisions;
        this.sourcePoint = sourcePoint;
        this.sourceDirection = sourceDirection;
        this.targetPoint = targetPoint;
        this.targetDirection = targetDirection;
    }

    public OrthogonalSearchRouter.Solution route() {
        this.sourceBoundaryPoint = this.findBoundaryPoint(this.sourcePoint, this.sourceDirection);
        this.targetBoundaryPoint = this.findBoundaryPoint(this.targetPoint, this.targetDirection);
        this.search(new OrthogonalSearchRouterRegion(this.sourceBoundaryPoint.x, this.sourceBoundaryPoint.y, 0, 0, this.sourceDirection, 0));
        return this.bestControlPoints != null ? new OrthogonalSearchRouter.Solution(this.bestControlPointsPrice, Arrays.asList(this.bestControlPoints)) : null;
    }

    private Point findBoundaryPoint(Point point, Anchor.Direction direction) {
        ArrayList<Rectangle> collisions;
        point = new Point(point);
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                collisions = this.horizontalCollisions;
                break;
            }
            case BOTTOM: 
            case TOP: {
                collisions = this.verticalCollisions;
                break;
            }
            default: {
                return point;
            }
        }
        boolean changed = true;
        block10: while (changed) {
            changed = false;
            switch (direction) {
                case LEFT: {
                    for (Rectangle rectangle : collisions) {
                        if (!rectangle.contains(point)) continue;
                        point.x = rectangle.x - 1;
                        changed = true;
                    }
                    continue block10;
                }
                case RIGHT: {
                    for (Rectangle rectangle : collisions) {
                        if (!rectangle.contains(point)) continue;
                        point.x = rectangle.x + rectangle.width;
                        changed = true;
                    }
                    continue block10;
                }
                case BOTTOM: {
                    for (Rectangle rectangle : collisions) {
                        if (!rectangle.contains(point)) continue;
                        point.y = rectangle.y + rectangle.height;
                        changed = true;
                    }
                    continue block10;
                }
                case TOP: {
                    for (Rectangle rectangle : collisions) {
                        if (!rectangle.contains(point)) continue;
                        point.y = rectangle.y - 1;
                        changed = true;
                    }
                    break;
                }
            }
        }
        return point;
    }

    private void search(OrthogonalSearchRouterRegion region) {
        Rectangle inter = region.intersection(this.scene.getMaximumBounds());
        region = new OrthogonalSearchRouterRegion(inter.x, inter.y, inter.width, inter.height, region.getDirection(), region.getDepth());
        if (region.width < 0 || region.height < 0) {
            return;
        }
        assert (region.x >= -20000);
        assert (region.y >= -20000);
        assert (region.x + region.width <= 20000);
        assert (region.y + region.height <= 20000);
        int depth = region.getDepth();
        if (depth >= 5) {
            return;
        }
        region.extendToInfinity();
        this.regions[depth] = region;
        ArrayList<Rectangle> collisions = region.isHorizontal() ? this.horizontalCollisions : this.verticalCollisions;
        ArrayList<OrthogonalSearchRouterRegion> subRegions = region.parseSubRegions(collisions);
        boolean updatedCollissions = false;
        if (!region.isEmpty()) {
            Rectangle updateCollisionsRect = new Rectangle(region);
            this.horizontalCollisions.add(updateCollisionsRect);
            this.verticalCollisions.add(updateCollisionsRect);
            updatedCollissions = true;
        }
        if (region.containsInsideEdges(this.targetBoundaryPoint)) {
            this.constructControlPoints(depth);
        } else {
            if (region.getLength() > 0) {
                this.search(region.cloneWithCounterClockwiseEdge());
                this.search(region.cloneWithClockwiseEdge());
            }
            if (!subRegions.isEmpty()) {
                for (OrthogonalSearchRouterRegion subRegion : subRegions) {
                    this.search(subRegion);
                }
            }
        }
        if (updatedCollissions) {
            this.horizontalCollisions.remove(this.horizontalCollisions.size() - 1);
            this.verticalCollisions.remove(this.verticalCollisions.size() - 1);
        }
    }

    private void constructControlPoints(int depth) {
        int a;
        Anchor.Direction desiredDirection;
        switch (this.targetDirection) {
            case LEFT: {
                desiredDirection = Anchor.Direction.RIGHT;
                break;
            }
            case RIGHT: {
                desiredDirection = Anchor.Direction.LEFT;
                break;
            }
            case TOP: {
                desiredDirection = Anchor.Direction.BOTTOM;
                break;
            }
            case BOTTOM: {
                desiredDirection = Anchor.Direction.TOP;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (desiredDirection != this.regions[depth].getDirection()) {
            OrthogonalSearchRouterRegion region = this.regions[depth];
            this.regions[++depth] = new OrthogonalSearchRouterRegion(region.x, region.y, region.width, region.height, desiredDirection, depth);
        }
        Point[] controlPoints = new Point[depth + 4];
        controlPoints[0] = new Point(this.sourcePoint);
        controlPoints[1] = new Point(this.sourceBoundaryPoint);
        for (a = 2; a < depth + 2; ++a) {
            controlPoints[a] = new Point();
        }
        controlPoints[depth + 2] = new Point(this.targetBoundaryPoint);
        controlPoints[depth + 3] = new Point(this.targetPoint);
        for (a = 0; a < depth; ++a) {
            int xx;
            OrthogonalSearchRouterRegion region = this.regions[a];
            Point previousPoint = controlPoints[a + 1];
            Point currentPoint = controlPoints[a + 2];
            if (region.isHorizontal()) {
                int yy;
                if (a > 0) {
                    int y1 = region.y;
                    int y2 = region.y + region.height;
                    yy = y1 <= -20000 && y2 < 20000 ? y2 - 8 : (y1 > -20000 && y2 >= 20000 ? y1 + 8 : region.y + region.height / 2);
                } else {
                    yy = previousPoint.y;
                }
                previousPoint.y = currentPoint.y = yy;
                continue;
            }
            if (a > 0) {
                int x1 = region.x;
                int x2 = region.x + region.width;
                xx = x1 <= -20000 && x2 < 20000 ? x2 - 8 : (x1 > -20000 && x2 >= 20000 ? x1 + 8 : region.x + region.width / 2);
            } else {
                xx = previousPoint.x;
            }
            previousPoint.x = currentPoint.x = xx;
        }
        if (this.regions[depth].isHorizontal()) {
            controlPoints[depth + 1].y = controlPoints[depth + 2].y;
        } else {
            controlPoints[depth + 1].x = controlPoints[depth + 2].x;
        }
        int controlPointsLength = this.removeDuplicateControlPoints(controlPoints);
        int price = this.calculatePrice(controlPointsLength, controlPoints);
        if (this.bestControlPoints == null || this.bestControlPointsPrice > price) {
            if (controlPointsLength < controlPoints.length) {
                this.bestControlPoints = new Point[controlPointsLength];
                System.arraycopy(controlPoints, 0, this.bestControlPoints, 0, controlPointsLength);
            } else {
                this.bestControlPoints = controlPoints;
            }
            this.bestControlPointsPrice = price;
        }
    }

    private int removeDuplicateControlPoints(Point[] controlPoints) {
        int newPointsLength = 0;
        for (int a = 1; a < controlPoints.length - 1; ++a) {
            Point p0 = controlPoints[newPointsLength];
            Point p1 = controlPoints[a];
            Point p2 = controlPoints[a + 1];
            if (p0.x == p1.x && p1.x == p2.x || p0.y == p1.y && p1.y == p2.y || ++newPointsLength == a) continue;
            controlPoints[newPointsLength] = p1;
        }
        if (++newPointsLength < controlPoints.length - 1) {
            controlPoints[newPointsLength++] = controlPoints[controlPoints.length - 1];
        }
        return newPointsLength;
    }

    private int calculatePrice(int controlPointsLength, Point[] controlPoints) {
        int price = 0;
        for (int a = 1; a < controlPointsLength; ++a) {
            Point p1 = controlPoints[a - 1];
            Point p2 = controlPoints[a];
            price += Math.abs(p2.y - p1.y) + Math.abs(p2.x - p1.x) + 200;
        }
        if (controlPointsLength > 0) {
            int average = price / controlPointsLength;
            int diff = 0;
            for (int a = 1; a < controlPointsLength; ++a) {
                Point p1 = controlPoints[a - 1];
                Point p2 = controlPoints[a];
                diff += Math.abs(Math.abs(p2.y - p1.y) + Math.abs(p2.x - p1.x) - average);
            }
            price += (diff /= controlPointsLength);
        }
        return price;
    }
}

