/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.INumber;
import math.UndefinedOperationException;

public class RealComplexINumber
implements INumber {
    private double a;
    private double b;

    public RealComplexINumber() {
        this(0.0, 0.0);
    }

    public RealComplexINumber(double real) {
        this(real, 0.0);
    }

    public RealComplexINumber(double real, double im) {
        this.a = real;
        this.b = im;
    }

    public INumber add(INumber no) {
        RealComplexINumber cn = this.getComplexINumber(no);
        return new RealComplexINumber(this.a + cn.a, this.b + cn.b);
    }

    public INumber subtract(INumber no) {
        RealComplexINumber cn = this.getComplexINumber(no);
        return new RealComplexINumber(this.a - cn.a, this.b - cn.b);
    }

    public INumber multiply(INumber no) {
        RealComplexINumber cn = this.getComplexINumber(no);
        double rp = this.a * cn.a - this.b * cn.b;
        double ip = this.a * cn.b - this.b * cn.a;
        return new RealComplexINumber(rp, ip);
    }

    public INumber min(INumber no) {
        throw new UndefinedOperationException();
    }

    public INumber max(INumber no) {
        throw new UndefinedOperationException();
    }

    public INumber divide(INumber no) {
        RealComplexINumber cn = this.getComplexINumber(no);
        if (cn.a + cn.b == 0.0) {
            throw new UndefinedOperationException();
        }
        return null;
    }

    public INumber negate() {
        return new RealComplexINumber(-1.0 * this.a, -1.0 * this.b);
    }

    public boolean isReal() {
        return this.b == 0.0;
    }

    public boolean isDecimal() {
        return false;
    }

    public INumber abs() {
        return new RealComplexINumber(this.absAsRealNumber(), 0.0);
    }

    public double absAsRealNumber() {
        return Math.hypot(this.a, this.b);
    }

    public INumber sdruzene() {
        return new RealComplexINumber(this.a, -1.0 * this.b);
    }

    public INumber prevracene() {
        double d = this.absAsRealNumber();
        return null;
    }

    private RealComplexINumber getComplexINumber(INumber no) {
        if (!(no instanceof RealComplexINumber)) {
            throw new UndefinedOperationException();
        }
        return (RealComplexINumber)no;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(12);
        if (this.a != 0.0) {
            if (this.a > 0.0) {
                retVal.append(this.a);
            } else {
                retVal.append(" - ");
                retVal.append(Math.abs(this.a));
            }
        }
        if (this.b != 0.0) {
            retVal.append(" ");
            if (this.b > 0.0) {
                if (this.a != 0.0) {
                    retVal.append("+ ");
                }
                if (this.b != 1.0) {
                    retVal.append(this.b);
                }
            } else {
                retVal.append("- ");
                if (this.b != -1.0) {
                    retVal.append(Math.abs(this.b));
                }
            }
            retVal.append("i");
        }
        return retVal.toString().trim().replace(".0", "");
    }

    public boolean equals(Object obj) {
        boolean retVal = obj instanceof RealComplexINumber;
        if (retVal) {
            RealComplexINumber cn = (RealComplexINumber)obj;
            retVal = this.a == cn.a && this.b == cn.b;
        }
        return retVal;
    }

    public int hashCode() {
        return (int)(this.a * 5.0 + this.b * 7.0 + 27.0);
    }
}

