/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int infixPrecedenceLevels = 10;
    private Scanner S;
    private TreeMaker F;
    private Log log;
    private Keywords keywords;
    private Source source;
    private Name.Table names;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean keepDocComments;
    boolean genEndPos;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    private int mode = 0;
    private int lastmode = 0;
    static Tree errorTree;
    Map<Tree, String> docComments;
    Map<Tree, Integer> endPositions;
    private static List<String> emptyStringList;
    ListBuffer<Tree[]> odStackSupply = new ListBuffer();
    ListBuffer<Tokens[]> opStackSupply = new ListBuffer();
    static final /* synthetic */ int[] $SwitchMap$com$sun$tools$javac$parser$Tokens;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$parser$Parser;

    protected Parser(Factory fac, Scanner S, boolean keepDocComments) {
        this.S = S;
        S.nextToken();
        this.F = fac.F;
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.source = fac.source;
        Options options = fac.options;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.keepDocComments = keepDocComments;
        boolean bl = this.genEndPos = options.get("-Xjcov") != null;
        if (keepDocComments) {
            this.docComments = new HashMap<Tree, String>();
        }
        if (this.genEndPos) {
            this.endPositions = new HashMap<Tree, Integer>();
        }
    }

    private void skip() {
        int nbraces = 0;
        int nparens = 0;
        while (true) {
            switch (this.S.token()) {
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case SEMI: {
                    if (nbraces != 0 || nparens != 0) break;
                    return;
                }
                case RBRACE: {
                    if (nbraces == 0) {
                        return;
                    }
                    --nbraces;
                    break;
                }
                case RPAREN: {
                    if (nparens <= 0) break;
                    --nparens;
                    break;
                }
                case LBRACE: {
                    ++nbraces;
                    break;
                }
                case LPAREN: {
                    ++nparens;
                    break;
                }
            }
            this.S.nextToken();
        }
    }

    private Tree syntaxError(int pos, String key, String arg) {
        if (pos != this.S.errPos()) {
            this.log.error(pos, key, new Object[]{arg});
        }
        this.skip();
        this.S.errPos(pos);
        return this.F.at(pos).Erroneous();
    }

    private Tree syntaxError(int pos, String key) {
        return this.syntaxError(pos, key, null);
    }

    private Tree syntaxError(String key) {
        return this.syntaxError(this.S.pos(), key, null);
    }

    private Tree syntaxError(String key, String arg) {
        return this.syntaxError(this.S.pos(), key, arg);
    }

    private void accept(Tokens token) {
        if (this.S.token() == token) {
            this.S.nextToken();
        } else {
            this.syntaxError(this.S.prevEndPos(), "expected", this.keywords.token2string(token));
            if (this.S.token() == token) {
                this.S.nextToken();
            }
        }
    }

    Tree illegal(int pos) {
        if ((this.mode & 1) != 0) {
            return this.syntaxError(pos, "illegal.start.of.expr");
        }
        return this.syntaxError(pos, "illegal.start.of.type");
    }

    Tree illegal() {
        return this.illegal(this.S.pos());
    }

    void checkNoMods(long mods) {
        if (mods != 0L) {
            long lowestMod = mods & -mods;
            this.log.error(this.S.pos(), "mod.not.allowed.here", new Object[]{Flags.toString(lowestMod).trim()});
        }
    }

    void attach(Tree tree, String dc) {
        if (this.keepDocComments && dc != null) {
            this.docComments.put(tree, dc);
        }
    }

    private final void storeEnd(Tree tree, int endpos) {
        if (this.genEndPos) {
            this.endPositions.put(tree, new Integer(endpos));
        }
    }

    int getStartPos(Tree tree) {
        if (tree == null) {
            return -1;
        }
        switch (tree.tag) {
            case 26: {
                return this.getStartPos(((Tree.Apply)tree).meth);
            }
            case 30: {
                return this.getStartPos(((Tree.Assign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getStartPos(((Tree.Assignop)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getStartPos(((Tree.Binary)tree).lhs);
            }
            case 3: {
                Tree.ClassDef node = (Tree.ClassDef)tree;
                if (node.mods.pos == -1) break;
                return node.mods.pos;
            }
            case 18: {
                return this.getStartPos(((Tree.Conditional)tree).cond);
            }
            case 20: {
                return this.getStartPos(((Tree.Exec)tree).expr);
            }
            case 33: {
                return this.getStartPos(((Tree.Indexed)tree).indexed);
            }
            case 4: {
                Tree.MethodDef node = (Tree.MethodDef)tree;
                if (node.mods.pos == -1) break;
                return node.mods.pos;
            }
            case 34: {
                return this.getStartPos(((Tree.Select)tree).selected);
            }
            case 39: {
                return this.getStartPos(((Tree.TypeApply)tree).clazz);
            }
            case 38: {
                return this.getStartPos(((Tree.TypeArray)tree).elemtype);
            }
            case 32: {
                return this.getStartPos(((Tree.TypeTest)tree).expr);
            }
            case 52: 
            case 53: {
                return this.getStartPos(((Tree.Unary)tree).arg);
            }
            case 5: {
                Tree.VarDef node = (Tree.VarDef)tree;
                if (node.mods.pos != -1) {
                    return node.mods.pos;
                }
                return this.getStartPos(node.vartype);
            }
        }
        return tree.pos;
    }

    int getEndPos(Tree tree) {
        if (!this.genEndPos || tree == null) {
            return -1;
        }
        Integer mapPos = this.endPositions.get(tree);
        if (mapPos != null) {
            return mapPos;
        }
        switch (tree.tag) {
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.getEndPos(((Tree.Assignop)tree).rhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.getEndPos(((Tree.Binary)tree).rhs);
            }
            case 14: {
                return this.getEndPos(((Tree.Case)tree).stats.last());
            }
            case 17: {
                return this.getEndPos(((Tree.Catch)tree).body);
            }
            case 18: {
                return this.getEndPos(((Tree.Conditional)tree).falsepart);
            }
            case 10: {
                if (tree instanceof Tree.ForLoop) {
                    return this.getEndPos(((Tree.ForLoop)tree).body);
                }
                return this.getEndPos(((Tree.ForeachLoop)tree).body);
            }
            case 19: {
                Tree.If node = (Tree.If)tree;
                if (node.elsepart == null) {
                    return this.getEndPos(node.thenpart);
                }
                return this.getEndPos(node.elsepart);
            }
            case 12: {
                return this.getEndPos(((Tree.Labelled)tree).body);
            }
            case 44: {
                return this.getEndPos(((Tree.Modifiers)tree).annotations.last());
            }
            case 15: {
                return this.getEndPos(((Tree.Synchronized)tree).body);
            }
            case 1: {
                return this.getEndPos(((Tree.TopLevel)tree).defs.last());
            }
            case 16: {
                Tree.Try node = (Tree.Try)tree;
                if (node.finalizer == null) {
                    return this.getEndPos(node.catchers.last());
                }
                return this.getEndPos(node.finalizer);
            }
            case 41: {
                return this.getEndPos(((Tree.TypeArgument)tree).inner);
            }
            case 31: {
                return this.getEndPos(((Tree.TypeCast)tree).expr);
            }
            case 32: {
                return this.getEndPos(((Tree.TypeTest)tree).clazz);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return this.getEndPos(((Tree.Unary)tree).arg);
            }
            case 9: {
                return this.getEndPos(((Tree.WhileLoop)tree).body);
            }
        }
        return -1;
    }

    Name ident() {
        if (this.S.token() == Tokens.IDENTIFIER) {
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Tokens.ASSERT) {
            if (this.allowAsserts) {
                this.log.error(this.S.pos(), "assert.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "assert.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Tokens.ENUM) {
            if (this.allowEnums) {
                this.log.error(this.S.pos(), "enum.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "enum.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        this.accept(Tokens.IDENTIFIER);
        return this.names.error;
    }

    public Tree qualident() {
        Tree t = this.F.at(this.S.pos()).Ident(this.ident());
        this.storeEnd(t, this.S.prevEndPos());
        while (this.S.token() == Tokens.DOT) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.F.at(pos).Select(t, this.ident());
            this.storeEnd(t, this.S.prevEndPos());
        }
        return t;
    }

    Tree literal(Name prefix) {
        int pos = this.S.pos();
        Tree t = errorTree;
        switch (this.S.token()) {
            case INTLITERAL: {
                try {
                    t = this.F.at(pos).Literal(4, new Integer(Convert.string2int(this.strval(prefix), this.S.radix())));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos(), "int.number.too.large", new Object[]{this.strval(prefix)});
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    t = this.F.at(pos).Literal(5, new Long(Convert.string2long(this.strval(prefix), this.S.radix())));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos(), "int.number.too.large", new Object[]{this.strval(prefix)});
                }
                break;
            }
            case FLOATLITERAL: {
                Float n;
                String proper = this.S.radix() == 16 ? new StringBuffer().append("0x").append(this.S.stringVal()).toString() : this.S.stringVal();
                try {
                    n = Float.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = new Float(Float.NaN);
                }
                if (n.floatValue() == 0.0f && !this.isZero(proper)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(6, n);
                break;
            }
            case DOUBLELITERAL: {
                Double n;
                String proper = this.S.radix() == 16 ? new StringBuffer().append("0x").append(this.S.stringVal()).toString() : this.S.stringVal();
                try {
                    n = Double.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = new Double(Double.NaN);
                }
                if (n == 0.0 && !this.isZero(proper)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(7, n);
                break;
            }
            case CHARLITERAL: {
                t = this.F.at(pos).Literal(2, new Integer(this.S.stringVal().charAt(0) + '\u0000'));
                break;
            }
            case STRINGLITERAL: {
                t = this.F.at(pos).Literal(10, this.S.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: 
            case NULL: {
                t = this.F.at(pos).Ident(this.S.name());
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        if (t == errorTree) {
            t = this.F.at(pos).Erroneous();
        }
        this.storeEnd(t, this.S.endPos());
        this.S.nextToken();
        return t;
    }

    boolean isZero(String s) {
        int i;
        char[] cs = s.toCharArray();
        int base = Character.toLowerCase(s.charAt(1)) == 'x' ? 16 : 10;
        int n = i = base == 16 ? 2 : 0;
        while (i < cs.length && (cs[i] == '0' || cs[i] == '.')) {
            ++i;
        }
        return i >= cs.length || Character.digit(cs[i], base) <= 0;
    }

    String strval(Name prefix) {
        String s = this.S.stringVal();
        return prefix.len == 0 ? s : new StringBuffer().append(prefix).append(s).toString();
    }

    Tree expression() {
        return this.term(1);
    }

    Tree type() {
        return this.term(2);
    }

    Tree term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        Tree t = this.term();
        this.lastmode = this.mode;
        this.mode = prevmode;
        return t;
    }

    Tree term() {
        Tree t = this.term1();
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.EQ || Tokens.PLUSEQ.compareTo(this.S.token()) <= 0 && this.S.token().compareTo(Tokens.GTGTGTEQ) <= 0) {
            return this.termRest(t);
        }
        return t;
    }

    Tree termRest(Tree t) {
        switch (this.S.token()) {
            case EQ: {
                int pos = this.S.pos();
                this.S.nextToken();
                this.mode = 1;
                Tree t1 = this.term();
                t = this.F.at(pos).Assign(t, t1);
                this.storeEnd(t, this.S.prevEndPos());
                return t;
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int pos = this.S.pos();
                Tokens token = this.S.token();
                this.S.nextToken();
                this.mode = 1;
                Tree t1 = this.term();
                return this.F.at(pos).Assignop(Parser.optag(token), t, t1);
            }
        }
        return t;
    }

    Tree term1() {
        Tree t = this.term2();
        if ((this.mode & 1) != 0 & this.S.token() == Tokens.QUES) {
            this.mode = 1;
            return this.term1Rest(t);
        }
        return t;
    }

    Tree term1Rest(Tree t) {
        if (this.S.token() == Tokens.QUES) {
            int pos = this.S.pos();
            this.S.nextToken();
            Tree t1 = this.term();
            this.accept(Tokens.COLON);
            Tree t2 = this.term1();
            return this.F.at(pos).Conditional(t, t1, t2);
        }
        return t;
    }

    Tree term2() {
        Tree t = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.S.token()) >= 4) {
            this.mode = 1;
            return this.term2Rest(t, 4);
        }
        return t;
    }

    Tree term2Rest(Tree t, int minprec) {
        StringBuffer buf;
        List savedOd = this.odStackSupply.elems;
        Tree[] odStack = this.newOdStack();
        List savedOp = this.opStackSupply.elems;
        Tokens[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int startPos = this.S.pos();
        Tokens topOp = Tokens.ERROR;
        while (Parser.prec(this.S.token()) >= minprec) {
            opStack[top] = topOp;
            topOp = this.S.token();
            int pos = this.S.pos();
            this.S.nextToken();
            Tree tree = odStack[++top] = topOp == Tokens.INSTANCEOF ? this.type() : this.term3();
            while (top > 0 && Parser.prec(topOp) >= Parser.prec(this.S.token())) {
                odStack[top - 1] = this.makeOp(pos, topOp, odStack[top - 1], odStack[top]);
                topOp = opStack[--top];
            }
        }
        if (!$assertionsDisabled && top != 0) {
            throw new AssertionError();
        }
        t = odStack[0];
        if (t.tag == 69 && (buf = this.foldStrings(t)) != null) {
            t = this.F.at(startPos).Literal(10, buf.toString());
            this.storeEnd(t, this.S.prevEndPos());
        }
        this.odStackSupply.elems = savedOd;
        this.opStackSupply.elems = savedOp;
        return t;
    }

    private Tree makeOp(int pos, Tokens topOp, Tree od1, Tree od2) {
        if (topOp == Tokens.INSTANCEOF) {
            return this.F.at(pos).TypeTest(od1, od2);
        }
        return this.F.at(pos).Binary(Parser.optag(topOp), od1, od2);
    }

    protected StringBuffer foldStrings(Tree tree) {
        List<String> buf = emptyStringList;
        while (true) {
            if (tree.tag == 36) {
                Tree.Literal lit = (Tree.Literal)tree;
                if (lit.typetag != 10) break;
                StringBuffer sbuf = new StringBuffer((String)lit.value);
                while (buf.nonEmpty()) {
                    sbuf.append((String)buf.head);
                    buf = buf.tail;
                }
                return sbuf;
            }
            if (tree.tag != 69) break;
            Tree.Binary op = (Tree.Binary)tree;
            if (op.rhs.tag != 36) break;
            Tree.Literal lit = (Tree.Literal)op.rhs;
            if (lit.typetag != 10) break;
            buf = buf.prepend((String)lit.value);
            tree = op.lhs;
        }
        return null;
    }

    private Tree[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new Tree[11]);
        }
        Tree[] odStack = (Tree[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return odStack;
    }

    private Tokens[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new Tokens[11]);
        }
        Tokens[] opStack = (Tokens[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return opStack;
    }

    Tree term3() {
        Tree t;
        int pos = this.S.pos();
        List<Tree> typeArgs = this.typeArgumentsOpt(1);
        switch (this.S.token()) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case BANG: 
            case TILDE: 
            case PLUSPLUS: 
            case SUBSUB: 
            case PLUS: 
            case SUB: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    Tokens token = this.S.token();
                    this.S.nextToken();
                    this.mode = 1;
                    if (token == Tokens.SUB && (this.S.token() == Tokens.INTLITERAL || this.S.token() == Tokens.LONGLITERAL) && this.S.radix() == 10) {
                        this.mode = 1;
                        t = this.literal(this.names.hyphen);
                        break;
                    }
                    Tree t2 = this.term3();
                    return this.F.at(pos).Unary(Parser.unoptag(token), t2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    t = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token() == Tokens.LT) {
                        int op = 62;
                        int pos1 = this.S.pos();
                        this.S.nextToken();
                        this.mode &= 3;
                        this.mode |= 8;
                        Tree t1 = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token() == Tokens.COMMA || this.S.token() == Tokens.GT)) {
                            this.mode = 2;
                            ListBuffer<Tree> args = new ListBuffer<Tree>();
                            args.append(t1);
                            while (this.S.token() == Tokens.COMMA) {
                                this.S.nextToken();
                                args.append(this.typeArgument());
                            }
                            this.accept(Tokens.GT);
                            t = this.F.at(pos1).TypeApply(t, args.toList());
                            this.checkGenerics();
                            this.storeEnd(t, this.S.prevEndPos());
                            t = this.bracketsOpt(t);
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            t = this.F.at(pos1).Binary(op, t, this.term2Rest(t1, 11));
                            t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                        } else {
                            this.accept(Tokens.GT);
                        }
                    } else {
                        t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                    }
                    this.accept(Tokens.RPAREN);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        Tree t1 = this.term3();
                        return this.F.at(pos).TypeCast(t, t1);
                    }
                    if ((this.lastmode & 2) != 0) {
                        switch (this.S.token()) {
                            case ENUM: 
                            case LPAREN: 
                            case INTLITERAL: 
                            case LONGLITERAL: 
                            case FLOATLITERAL: 
                            case DOUBLELITERAL: 
                            case CHARLITERAL: 
                            case STRINGLITERAL: 
                            case TRUE: 
                            case FALSE: 
                            case NULL: 
                            case BANG: 
                            case TILDE: 
                            case THIS: 
                            case SUPER: 
                            case NEW: 
                            case IDENTIFIER: 
                            case ASSERT: 
                            case BYTE: 
                            case SHORT: 
                            case CHAR: 
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case VOID: {
                                Tree t1 = this.term3();
                                return this.F.at(pos).TypeCast(t, t1);
                            }
                        }
                    }
                } else {
                    return this.illegal();
                }
                t = this.F.at(pos).Parens(t);
                this.storeEnd(t, this.S.prevEndPos());
                break;
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.F.at(pos).Ident(this.names._this);
                    this.storeEnd(t, this.S.endPos());
                    this.S.nextToken();
                    t = typeArgs == null ? this.argumentsOpt(null, t) : this.arguments(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.superSuffix(typeArgs, this.F.at(pos).Ident(this.names._super));
                    this.storeEnd(t, this.S.endPos());
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    if (this.S.token() == Tokens.LT) {
                        typeArgs = this.typeArguments();
                    }
                    t = this.creator(pos, typeArgs);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case ENUM: 
            case IDENTIFIER: 
            case ASSERT: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                t = this.F.at(this.S.pos()).Ident(this.ident());
                this.storeEnd(t, this.S.prevEndPos());
                block27: while (true) {
                    pos = this.S.pos();
                    switch (this.S.token()) {
                        case LBRACKET: {
                            this.S.nextToken();
                            if (this.S.token() == Tokens.RBRACKET) {
                                this.S.nextToken();
                                t = this.bracketsOpt(t);
                                t = this.F.at(pos).TypeArray(t);
                                this.storeEnd(t, this.S.prevEndPos());
                                t = this.bracketsSuffix(t);
                                break block27;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                Tree t1 = this.term();
                                t = this.F.at(pos).Indexed(t, t1);
                                this.storeEnd(t, this.S.endPos());
                            }
                            this.accept(Tokens.RBRACKET);
                            break block27;
                        }
                        case LPAREN: {
                            if ((this.mode & 1) == 0) break block27;
                            this.mode = 1;
                            t = this.arguments(typeArgs, t);
                            typeArgs = null;
                            break block27;
                        }
                        case DOT: {
                            this.S.nextToken();
                            typeArgs = this.typeArgumentsOpt(1);
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token()) {
                                    case CLASS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.F.at(pos).Select(t, this.names._class);
                                        this.storeEnd(t, this.S.endPos());
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case THIS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.F.at(pos).Select(t, this.names._this);
                                        this.storeEnd(t, this.S.endPos());
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case SUPER: {
                                        this.mode = 1;
                                        t = this.F.at(pos).Select(t, this.names._super);
                                        this.storeEnd(t, this.S.endPos());
                                        t = this.superSuffix(typeArgs, t);
                                        typeArgs = null;
                                        break block27;
                                    }
                                    case NEW: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        int pos1 = this.S.pos();
                                        this.S.nextToken();
                                        if (this.S.token() == Tokens.LT) {
                                            typeArgs = this.typeArguments();
                                        }
                                        t = this.innerCreator(pos1, typeArgs, t);
                                        typeArgs = null;
                                        break block27;
                                    }
                                }
                            }
                            t = this.F.at(pos).Select(t, this.ident());
                            this.storeEnd(t, this.S.prevEndPos());
                            continue block27;
                        }
                    }
                    break;
                }
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (typeArgs != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token() == Tokens.DOT) {
                        Tree.TypeIdent ti = this.F.at(pos).TypeIdent(9);
                        this.storeEnd(ti, this.S.prevEndPos());
                        t = this.bracketsSuffix(ti);
                        break;
                    }
                    return this.illegal(pos);
                }
                return this.illegal();
            }
            default: {
                return this.illegal();
            }
        }
        if (typeArgs != null) {
            this.illegal();
        }
        while (true) {
            int pos1 = this.S.pos();
            if (this.S.token() == Tokens.LBRACKET) {
                this.S.nextToken();
                if ((this.mode & 2) != 0) {
                    int oldmode = this.mode;
                    this.mode = 2;
                    if (this.S.token() == Tokens.RBRACKET) {
                        this.S.nextToken();
                        t = this.bracketsOpt(t);
                        t = this.F.at(pos1).TypeArray(t);
                        this.storeEnd(t, this.S.prevEndPos());
                        return t;
                    }
                    this.mode = oldmode;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    Tree t1 = this.term();
                    t = this.F.at(pos1).Indexed(t, t1);
                    this.storeEnd(t, this.S.endPos());
                }
                this.accept(Tokens.RBRACKET);
                continue;
            }
            if (this.S.token() != Tokens.DOT) break;
            this.S.nextToken();
            typeArgs = this.typeArgumentsOpt(1);
            if (this.S.token() == Tokens.SUPER && (this.mode & 1) != 0) {
                this.mode = 1;
                t = this.F.at(pos1).Select(t, this.names._super);
                this.storeEnd(t, this.S.endPos());
                this.S.nextToken();
                t = this.arguments(typeArgs, t);
                typeArgs = null;
                continue;
            }
            if (this.S.token() == Tokens.NEW && (this.mode & 1) != 0) {
                if (typeArgs != null) {
                    return this.illegal();
                }
                this.mode = 1;
                int pos2 = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Tokens.LT) {
                    typeArgs = this.typeArguments();
                }
                t = this.innerCreator(pos2, typeArgs, t);
                typeArgs = null;
                continue;
            }
            t = this.F.at(pos1).Select(t, this.ident());
            this.storeEnd(t, this.S.prevEndPos());
            t = this.argumentsOpt(typeArgs, this.typeArgumentsOpt(t));
            typeArgs = null;
        }
        while ((this.S.token() == Tokens.PLUSPLUS || this.S.token() == Tokens.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            t = this.F.at(this.S.pos()).Unary(this.S.token() == Tokens.PLUSPLUS ? 52 : 53, t);
            this.storeEnd(t, this.S.endPos());
            this.S.nextToken();
        }
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree superSuffix(List<Tree> typeArgs, Tree t) {
        this.S.nextToken();
        if (this.S.token() == Tokens.LPAREN || typeArgs != null) {
            t = this.arguments(typeArgs, t);
        } else {
            int pos = this.S.pos();
            this.accept(Tokens.DOT);
            typeArgs = this.S.token() == Tokens.LT ? this.typeArguments() : null;
            t = this.F.at(pos).Select(t, this.ident());
            this.storeEnd(t, this.S.prevEndPos());
            t = this.argumentsOpt(typeArgs, t);
        }
        return t;
    }

    Tree basicType() {
        Tree.TypeIdent t = this.F.at(this.S.pos()).TypeIdent(Parser.typetag(this.S.token()));
        this.storeEnd(t, this.S.endPos());
        this.S.nextToken();
        return t;
    }

    Tree argumentsOpt(List<Tree> typeArgs, Tree t) {
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.LPAREN || typeArgs != null) {
            this.mode = 1;
            return this.arguments(typeArgs, t);
        }
        return t;
    }

    List<Tree> arguments() {
        int pos = this.S.pos();
        ListBuffer<Tree> args = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.LPAREN) {
            this.S.nextToken();
            if (this.S.token() != Tokens.RPAREN) {
                args.append(this.expression());
                while (this.S.token() == Tokens.COMMA) {
                    this.S.nextToken();
                    args.append(this.expression());
                }
            }
            this.accept(Tokens.RPAREN);
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
        }
        return args.toList();
    }

    Tree arguments(List<Tree> typeArgs, Tree t) {
        int pos = this.S.pos();
        List<Tree> args = this.arguments();
        t = this.F.at(pos).Apply(typeArgs, t, args);
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree typeArgumentsOpt(Tree t) {
        if (this.S.token() == Tokens.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(t);
        }
        return t;
    }

    List<Tree> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<Tree> typeArgumentsOpt(int useMode) {
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            if ((this.mode & useMode) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = useMode;
            return this.typeArguments();
        }
        return null;
    }

    List<Tree> typeArguments() {
        int pos = this.S.pos();
        ListBuffer<Tree> args = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.LT) {
            this.S.nextToken();
            args.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                args.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            }
            switch (this.S.token()) {
                case GTGTGTEQ: {
                    this.S.token(Tokens.GTGTEQ);
                    break;
                }
                case GTGTEQ: {
                    this.S.token(Tokens.GTEQ);
                    break;
                }
                case GTEQ: {
                    this.S.token(Tokens.EQ);
                    break;
                }
                case GTGTGT: {
                    this.S.token(Tokens.GTGT);
                    break;
                }
                case GTGT: {
                    this.S.token(Tokens.GT);
                    break;
                }
                default: {
                    this.accept(Tokens.GT);
                    break;
                }
            }
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LT));
        }
        return args.toList();
    }

    Tree typeArgument() {
        Tree.TypeBoundKind tbk = null;
        if (this.S.token() != Tokens.QUES) {
            return this.type();
        }
        int pos = this.S.pos();
        this.S.nextToken();
        if (this.S.token() == Tokens.EXTENDS) {
            tbk = this.F.at(this.S.pos()).TypeBoundKind(BoundKind.EXTENDS);
            this.storeEnd(tbk, this.S.endPos());
            this.S.nextToken();
            return this.F.at(pos).TypeArgument(tbk, this.type());
        }
        if (this.S.token() == Tokens.SUPER) {
            tbk = this.F.at(this.S.pos()).TypeBoundKind(BoundKind.SUPER);
            this.storeEnd(tbk, this.S.endPos());
            this.S.nextToken();
            return this.F.at(pos).TypeArgument(tbk, this.type());
        }
        tbk = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
        Tree.TypeArgument t = this.F.at(pos).TypeArgument(tbk, null);
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree typeArguments(Tree t) {
        int pos = this.S.pos();
        List<Tree> args = this.typeArguments();
        t = this.F.at(pos).TypeApply(t, args);
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    private Tree bracketsOpt(Tree t) {
        if (this.S.token() == Tokens.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.bracketsOptCont(t, pos);
            this.F.at(pos);
        }
        return t;
    }

    private Tree bracketsOptCont(Tree t, int pos) {
        this.accept(Tokens.RBRACKET);
        t = this.bracketsOpt(t);
        t = this.F.at(pos).TypeArray(t);
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree bracketsSuffix(Tree t) {
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.DOT) {
            this.mode = 1;
            int pos = this.S.pos();
            this.S.nextToken();
            this.accept(Tokens.CLASS);
            t = this.F.at(pos).Select(t, this.names._class);
            this.storeEnd(t, this.S.prevEndPos());
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.syntaxError(this.S.pos(), "dot.class.expected");
        }
        return t;
    }

    Tree creator(int newpos, List<Tree> typeArgs) {
        switch (this.S.token()) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) break;
                return this.arrayCreatorRest(newpos, this.basicType());
            }
        }
        Tree t = this.qualident();
        int oldmode = this.mode;
        this.mode = 2;
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            t = this.typeArguments(t);
        }
        this.mode = oldmode;
        if (this.S.token() == Tokens.LBRACKET) {
            return this.arrayCreatorRest(newpos, t);
        }
        if (this.S.token() == Tokens.LPAREN) {
            return this.classCreatorRest(newpos, null, typeArgs, t);
        }
        return this.syntaxError("left-paren.or.left-square-bracket.expected");
    }

    Tree innerCreator(int newpos, List<Tree> typeArgs, Tree encl) {
        Tree t = this.F.at(this.S.pos()).Ident(this.ident());
        this.storeEnd(t, this.S.prevEndPos());
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            t = this.typeArguments(t);
        }
        return this.classCreatorRest(newpos, encl, typeArgs, t);
    }

    Tree arrayCreatorRest(int newpos, Tree elemtype) {
        this.accept(Tokens.LBRACKET);
        if (this.S.token() == Tokens.RBRACKET) {
            this.accept(Tokens.RBRACKET);
            elemtype = this.bracketsOpt(elemtype);
            if (this.S.token() == Tokens.LBRACE) {
                return this.arrayInitializer(newpos, elemtype);
            }
            return this.syntaxError(this.S.pos(), "array.dimension.missing");
        }
        ListBuffer<Tree> dims = new ListBuffer<Tree>();
        dims.append(this.expression());
        this.accept(Tokens.RBRACKET);
        while (this.S.token() == Tokens.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Tokens.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos);
                continue;
            }
            dims.append(this.expression());
            this.accept(Tokens.RBRACKET);
        }
        Tree.NewArray t1 = this.F.at(newpos).NewArray(elemtype, dims.toList(), null);
        this.storeEnd(t1, this.S.prevEndPos());
        return t1;
    }

    Tree classCreatorRest(int newpos, Tree encl, List<Tree> typeArgs, Tree t) {
        List<Tree> args = this.arguments();
        Tree.ClassDef body = null;
        if (this.S.token() == Tokens.LBRACE) {
            body = this.F.at(this.S.pos()).ClassDef(this.F.Modifiers(0L), this.names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, this.classOrInterfaceBody(this.names.empty, false));
            this.storeEnd(body, this.S.prevEndPos());
        }
        t = this.F.at(newpos).NewClass(encl, typeArgs, t, args, body);
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree arrayInitializer(int newpos, Tree t) {
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> elems = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Tokens.RBRACE) {
            elems.append(this.variableInitializer());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Tokens.RBRACE) break;
                elems.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.RBRACE);
        t = this.F.at(newpos).NewArray(t, Tree.emptyList, elems.toList());
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    Tree variableInitializer() {
        return this.S.token() == Tokens.LBRACE ? this.arrayInitializer(this.S.pos(), null) : this.expression();
    }

    Tree parExpression() {
        int pos = this.S.pos();
        this.accept(Tokens.LPAREN);
        Tree t = this.expression();
        if (this.genEndPos) {
            t = this.F.at(pos).Parens(t);
            this.storeEnd(t, this.S.endPos());
        }
        this.accept(Tokens.RPAREN);
        return t;
    }

    Tree.Block block(int pos, long flags) {
        this.accept(Tokens.LBRACE);
        List<Tree> stats = this.blockStatements();
        Tree.Block t = this.F.at(pos).Block(flags, stats);
        while (this.S.token() == Tokens.CASE || this.S.token() == Tokens.DEFAULT) {
            this.syntaxError("orphaned", this.keywords.token2string(this.S.token()));
            this.blockStatements();
        }
        t.endpos = this.S.pos();
        this.storeEnd(t, this.S.endPos());
        this.accept(Tokens.RBRACE);
        return t;
    }

    Tree.Block block() {
        return this.block(this.S.pos(), 0L);
    }

    List<Tree> blockStatements() {
        ListBuffer<Tree> stats = new ListBuffer<Tree>();
        block8: while (true) {
            int pos = this.S.pos();
            switch (this.S.token()) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    return stats.toList();
                }
                case SEMI: 
                case LBRACE: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case SYNCHRONIZED: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    stats.append(this.statement());
                    continue block8;
                }
                case MONKEYS_AT: 
                case FINAL: {
                    String dc = this.S.docComment();
                    Tree.Modifiers mods = this.modifiersOpt();
                    if (this.S.token() == Tokens.INTERFACE || this.S.token() == Tokens.CLASS || this.allowEnums && this.S.token() == Tokens.ENUM) {
                        stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                        continue block8;
                    }
                    pos = this.S.pos();
                    Tree t = this.type();
                    stats.appendList(this.variableDeclarators(mods, t));
                    this.storeEnd((Tree)stats.elems.last(), this.S.endPos());
                    this.accept(Tokens.SEMI);
                    continue block8;
                }
                case ABSTRACT: 
                case STRICTFP: {
                    String dc = this.S.docComment();
                    Tree.Modifiers mods = this.modifiersOpt();
                    stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                    continue block8;
                }
                case CLASS: 
                case INTERFACE: {
                    stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                    continue block8;
                }
                case ENUM: 
                case ASSERT: {
                    if (this.allowEnums && this.S.token() == Tokens.ENUM) {
                        this.log.error(this.S.pos(), "local.enum", new Object[0]);
                        stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                        continue block8;
                    }
                    if (!this.allowAsserts || this.S.token() != Tokens.ASSERT) break;
                    stats.append(this.statement());
                    continue block8;
                }
            }
            Name name = this.S.name();
            Tree t = this.term(3);
            if (this.S.token() == Tokens.COLON && t.tag == 35) {
                this.S.nextToken();
                Tree stat = this.statement();
                stats.append(this.F.at(pos).Labelled(name, stat));
                continue;
            }
            if ((this.lastmode & 2) != 0 && (this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM)) {
                stats.appendList(this.variableDeclarators(this.F.at(-1).Modifiers(0L), t));
                this.storeEnd((Tree)stats.elems.last(), this.S.endPos());
                this.accept(Tokens.SEMI);
                continue;
            }
            Tree.Exec exec = this.F.at(pos).Exec(this.checkExprStat(t));
            this.storeEnd(exec, this.S.endPos());
            stats.append(exec);
            this.accept(Tokens.SEMI);
        }
    }

    Tree statement() {
        int pos = this.S.pos();
        switch (this.S.token()) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.S.nextToken();
                Tree cond = this.parExpression();
                Tree thenpart = this.statement();
                Tree elsepart = null;
                if (this.S.token() == Tokens.ELSE) {
                    this.S.nextToken();
                    elsepart = this.statement();
                }
                return this.F.at(pos).If(cond, thenpart, elsepart);
            }
            case FOR: {
                List<Tree> inits;
                this.S.nextToken();
                this.accept(Tokens.LPAREN);
                List<Tree> list = inits = this.S.token() == Tokens.SEMI ? Tree.emptyList : this.forInit();
                if (inits.length() == 1 && ((Tree)inits.head).tag == 5 && ((Tree.VarDef)inits.head).init == null && this.S.token() == Tokens.COLON) {
                    this.checkForeach();
                    Tree.VarDef var = (Tree.VarDef)inits.head;
                    this.accept(Tokens.COLON);
                    Tree expr = this.expression();
                    this.accept(Tokens.RPAREN);
                    Tree body = this.statement();
                    return this.F.at(pos).ForeachLoop(var, expr, body);
                }
                this.accept(Tokens.SEMI);
                Tree cond = this.S.token() == Tokens.SEMI ? null : this.expression();
                this.accept(Tokens.SEMI);
                List<Tree> steps = this.S.token() == Tokens.RPAREN ? Tree.emptyList : this.forUpdate();
                this.accept(Tokens.RPAREN);
                Tree body = this.statement();
                return this.F.at(pos).ForLoop(inits, cond, steps, body);
            }
            case WHILE: {
                this.S.nextToken();
                Tree cond = this.parExpression();
                Tree body = this.statement();
                return this.F.at(pos).WhileLoop(cond, body);
            }
            case DO: {
                this.S.nextToken();
                Tree body = this.statement();
                this.accept(Tokens.WHILE);
                Tree cond = this.parExpression();
                Tree.DoLoop t = this.F.at(pos).DoLoop(body, cond);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
            case TRY: {
                this.S.nextToken();
                Tree.Block body = this.block();
                ListBuffer<Tree.Catch> catchers = new ListBuffer<Tree.Catch>();
                Tree.Block finalizer = null;
                if (this.S.token() == Tokens.CATCH || this.S.token() == Tokens.FINALLY) {
                    while (this.S.token() == Tokens.CATCH) {
                        catchers.append(this.catchClause());
                    }
                    if (this.S.token() == Tokens.FINALLY) {
                        this.S.nextToken();
                        finalizer = this.block();
                    }
                } else {
                    this.log.error(pos, "try.without.catch.or.finally", new Object[0]);
                }
                return this.F.at(pos).Try(body, catchers.toList(), finalizer);
            }
            case SWITCH: {
                this.S.nextToken();
                Tree selector = this.parExpression();
                this.accept(Tokens.LBRACE);
                List<Tree.Case> cases = this.switchBlockStatementGroups();
                Tree.Switch t = this.F.at(pos).Switch(selector, cases);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.RBRACE);
                return t;
            }
            case SYNCHRONIZED: {
                this.S.nextToken();
                Tree lock = this.parExpression();
                Tree.Block body = this.block();
                return this.F.at(pos).Synchronized(lock, body);
            }
            case RETURN: {
                this.S.nextToken();
                Tree result = this.S.token() == Tokens.SEMI ? null : this.expression();
                Tree.Return t = this.F.at(pos).Return(result);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
            case THROW: {
                this.S.nextToken();
                Tree exc = this.expression();
                Tree.Throw t = this.F.at(pos).Throw(exc);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
            case BREAK: {
                this.S.nextToken();
                Name label = this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM ? this.ident() : null;
                Tree.Break t = this.F.at(pos).Break(label);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
            case CONTINUE: {
                this.S.nextToken();
                Name label = this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM ? this.ident() : null;
                Tree.Continue t = this.F.at(pos).Continue(label);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
            case SEMI: {
                Tree.Skip t = this.F.at(pos).Skip();
                this.storeEnd(t, this.S.endPos());
                this.S.nextToken();
                return t;
            }
            case ELSE: {
                return this.syntaxError("else.without.if");
            }
            case FINALLY: {
                return this.syntaxError("finally.without.try");
            }
            case CATCH: {
                return this.syntaxError("catch.without.try");
            }
            case ASSERT: {
                if (!this.allowAsserts || this.S.token() != Tokens.ASSERT) break;
                this.S.nextToken();
                Tree assertion = this.expression();
                Tree message = null;
                if (this.S.token() == Tokens.COLON) {
                    this.S.nextToken();
                    message = this.expression();
                }
                Tree.Assert t = this.F.at(pos).Assert(assertion, message);
                this.storeEnd(t, this.S.endPos());
                this.accept(Tokens.SEMI);
                return t;
            }
        }
        Name name = this.S.name();
        Tree expr = this.expression();
        if (this.S.token() == Tokens.COLON && expr.tag == 35) {
            this.S.nextToken();
            Tree stat = this.statement();
            return this.F.at(pos).Labelled(name, stat);
        }
        Tree.Exec stat = this.F.at(pos).Exec(this.checkExprStat(expr));
        this.storeEnd(stat, this.S.endPos());
        this.accept(Tokens.SEMI);
        return stat;
    }

    Tree.Catch catchClause() {
        int pos = this.S.pos();
        this.accept(Tokens.CATCH);
        this.accept(Tokens.LPAREN);
        Tree.VarDef formal = this.variableDeclaratorId(this.optFinal(0x200000000L), this.qualident());
        this.accept(Tokens.RPAREN);
        Tree.Block body = this.block();
        return this.F.at(pos).Catch(formal, body);
    }

    List<Tree.Case> switchBlockStatementGroups() {
        ListBuffer<Tree.Case> cases = new ListBuffer<Tree.Case>();
        block5: while (true) {
            int pos = this.S.pos();
            switch (this.S.token()) {
                case CASE: {
                    this.S.nextToken();
                    Tree pat = this.expression();
                    this.accept(Tokens.COLON);
                    List<Tree> stats = this.blockStatements();
                    Tree.Case c = this.F.at(pos).Case(pat, stats);
                    if (stats.isEmpty()) {
                        this.storeEnd(c, this.S.prevEndPos());
                    }
                    cases.append(c);
                    continue block5;
                }
                case DEFAULT: {
                    this.S.nextToken();
                    this.accept(Tokens.COLON);
                    List<Tree> stats = this.blockStatements();
                    Tree.Case c = this.F.at(pos).Case(null, stats);
                    if (stats.isEmpty()) {
                        this.storeEnd(c, this.S.prevEndPos());
                    }
                    cases.append(c);
                    continue block5;
                }
                case EOF: 
                case RBRACE: {
                    return cases.toList();
                }
            }
            this.S.nextToken();
            this.syntaxError(pos, "case.default.or.right-brace.expected");
        }
    }

    List<Tree> moreStatementExpressions(int pos, Tree first) {
        ListBuffer<Tree.Exec> stats = new ListBuffer<Tree.Exec>();
        Tree.Exec exec = this.F.at(pos).Exec(this.checkExprStat(first));
        this.storeEnd(exec, this.S.prevEndPos());
        stats.append(exec);
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            pos = this.S.pos();
            Tree t = this.expression();
            exec = this.F.at(pos).Exec(this.checkExprStat(t));
            this.storeEnd(exec, this.S.prevEndPos());
            stats.append(exec);
        }
        return stats.toList();
    }

    List<Tree> forInit() {
        int pos = this.S.pos();
        if (this.S.token() == Tokens.FINAL || this.S.token() == Tokens.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.type());
        }
        Tree t = this.term(3);
        if ((this.lastmode & 2) != 0 && (this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM)) {
            return this.variableDeclarators(this.modifiersOpt(), t);
        }
        return this.moreStatementExpressions(pos, t);
    }

    List<Tree> forUpdate() {
        return this.moreStatementExpressions(this.S.pos(), this.expression());
    }

    List<Tree.Annotation> annotationsOpt() {
        if (this.S.token() != Tokens.MONKEYS_AT) {
            return Tree.Annotation.emptyList;
        }
        ListBuffer<Tree.Annotation> buf = new ListBuffer<Tree.Annotation>();
        while (this.S.token() == Tokens.MONKEYS_AT) {
            int pos = this.S.pos();
            this.S.nextToken();
            buf.append(this.annotation(pos));
        }
        return buf.toList();
    }

    Tree.Modifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    Tree.Modifiers modifiersOpt(Tree.Modifiers partial) {
        long flags;
        long l = flags = partial == null ? 0L : partial.flags;
        if (this.S.deprecatedFlag()) {
            flags = 131072L;
            this.S.resetDeprecatedFlag();
        }
        ListBuffer<Tree.Annotation> annotations = new ListBuffer<Tree.Annotation>();
        if (partial != null) {
            annotations.appendList(partial.annotations);
        }
        int pos = this.S.pos();
        int lastPos = -1;
        block18: while (true) {
            long flag;
            switch (this.S.token()) {
                case PRIVATE: {
                    flag = 2L;
                    break;
                }
                case PROTECTED: {
                    flag = 4L;
                    break;
                }
                case PUBLIC: {
                    flag = 1L;
                    break;
                }
                case STATIC: {
                    flag = 8L;
                    break;
                }
                case TRANSIENT: {
                    flag = 128L;
                    break;
                }
                case FINAL: {
                    flag = 16L;
                    break;
                }
                case ABSTRACT: {
                    flag = 1024L;
                    break;
                }
                case NATIVE: {
                    flag = 256L;
                    break;
                }
                case VOLATILE: {
                    flag = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    flag = 32L;
                    break;
                }
                case STRICTFP: {
                    flag = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    flag = 8192L;
                    break;
                }
                default: {
                    break block18;
                }
            }
            if ((flags & flag) != 0L) {
                this.log.error(this.S.pos(), "repeated.modifier", new Object[0]);
            }
            lastPos = this.S.pos();
            this.S.nextToken();
            if (flag == 8192L) {
                this.checkAnnotations();
                if (this.S.token() != Tokens.INTERFACE) {
                    Tree.Annotation ann = this.annotation(lastPos);
                    if (flags == 0L && annotations.isEmpty()) {
                        pos = ann.pos;
                    }
                    annotations.append(ann);
                    lastPos = ann.pos;
                    flag = 0L;
                }
            }
            flags |= flag;
        }
        switch (this.S.token()) {
            case ENUM: {
                flags |= 0x4000L;
                break;
            }
            case INTERFACE: {
                flags |= 0x200L;
                break;
            }
        }
        if (flags == 0L && annotations.isEmpty()) {
            pos = -1;
        }
        Tree.Modifiers mods = this.F.at(pos).Modifiers(flags, annotations.toList());
        if (pos != -1) {
            this.storeEnd(mods, this.S.prevEndPos());
        }
        return mods;
    }

    Tree.Annotation annotation(int pos) {
        this.checkAnnotations();
        Tree ident = this.qualident();
        int endPos = this.S.prevEndPos();
        List<Tree> fieldValues = this.annotationFieldValuesOpt();
        Tree.Annotation ann = this.F.at(pos).Annotation(ident, fieldValues);
        this.storeEnd(ann, endPos);
        return ann;
    }

    List<Tree> annotationFieldValuesOpt() {
        return this.S.token() == Tokens.LPAREN ? this.annotationFieldValues() : Tree.emptyList;
    }

    List<Tree> annotationFieldValues() {
        int pos = this.S.pos();
        this.accept(Tokens.LPAREN);
        ListBuffer<Tree> buf = new ListBuffer<Tree>();
        if (this.S.token() != Tokens.RPAREN) {
            buf.append(this.annotationFieldValue());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                buf.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.RPAREN);
        return buf.toList();
    }

    Tree annotationFieldValue() {
        if (this.S.token() == Tokens.IDENTIFIER) {
            this.mode = 1;
            Tree t1 = this.term1();
            if (t1.tag == 35 && this.S.token() == Tokens.EQ) {
                int pos = this.S.pos();
                this.accept(Tokens.EQ);
                Tree.Assign t = this.F.at(pos).Assign(t1, this.annotationValue());
                this.storeEnd(t, this.S.prevEndPos());
                return t;
            }
            return t1;
        }
        return this.annotationValue();
    }

    Tree annotationValue() {
        switch (this.S.token()) {
            case MONKEYS_AT: {
                int pos = this.S.pos();
                this.S.nextToken();
                return this.annotation(pos);
            }
            case LBRACE: {
                int pos = this.S.pos();
                this.accept(Tokens.LBRACE);
                ListBuffer<Tree> buf = new ListBuffer<Tree>();
                if (this.S.token() != Tokens.RBRACE) {
                    buf.append(this.annotationValue());
                    while (this.S.token() == Tokens.COMMA) {
                        this.S.nextToken();
                        if (this.S.token() == Tokens.RPAREN) break;
                        buf.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.RBRACE);
                Tree.NewArray t = this.F.at(pos).NewArray(null, Tree.emptyList, buf.toList());
                this.storeEnd(t, this.S.prevEndPos());
                return t;
            }
        }
        this.mode = 1;
        return this.term1();
    }

    List<Tree> variableDeclarators(Tree.Modifiers mods, Tree type) {
        return this.variableDeclaratorsRest(this.S.pos(), mods, type, this.ident(), false, null);
    }

    List<Tree> variableDeclaratorsRest(int pos, Tree.Modifiers mods, Tree type, Name name, boolean reqInit, String dc) {
        ListBuffer<Tree.VarDef> vdefs = new ListBuffer<Tree.VarDef>();
        vdefs.append(this.variableDeclaratorRest(pos, mods, type, name, reqInit, dc));
        while (this.S.token() == Tokens.COMMA) {
            this.storeEnd((Tree)vdefs.elems.last(), this.S.endPos());
            this.S.nextToken();
            vdefs.append(this.variableDeclarator(mods, type, reqInit, dc));
        }
        return vdefs.toList();
    }

    Tree.VarDef variableDeclarator(Tree.Modifiers mods, Tree type, boolean reqInit, String dc) {
        return this.variableDeclaratorRest(this.S.pos(), mods, type, this.ident(), reqInit, dc);
    }

    Tree.VarDef variableDeclaratorRest(int pos, Tree.Modifiers mods, Tree type, Name name, boolean reqInit, String dc) {
        type = this.bracketsOpt(type);
        Tree init = null;
        if (this.S.token() == Tokens.EQ) {
            this.S.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.EQ));
        }
        Tree.VarDef result = this.F.at(pos).VarDef(mods, name, type, init);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    Tree.VarDef variableDeclaratorId(Tree.Modifiers mods, Tree type) {
        int pos = this.S.pos();
        Name name = this.ident();
        if ((mods.flags & 0x400000000L) == 0L) {
            type = this.bracketsOpt(type);
        }
        Tree.VarDef def = this.F.at(pos).VarDef(mods, name, type, null);
        this.storeEnd(def, this.S.prevEndPos());
        return def;
    }

    public Tree.TopLevel compilationUnit() {
        int pos = this.S.pos();
        Tree pid = null;
        String dc = this.S.docComment();
        Tree.Modifiers mods = null;
        List<Tree.Annotation> packageAnnotations = Tree.Annotation.emptyList;
        if (this.S.token() == Tokens.MONKEYS_AT) {
            mods = this.modifiersOpt();
        }
        if (this.S.token() == Tokens.PACKAGE) {
            if (mods != null) {
                this.checkNoMods(mods.flags);
                packageAnnotations = mods.annotations;
                mods = null;
            }
            this.S.nextToken();
            pid = this.qualident();
            this.accept(Tokens.SEMI);
        }
        ListBuffer<Tree> defs = new ListBuffer<Tree>();
        while (mods == null && this.S.token() == Tokens.IMPORT) {
            defs.append(this.importDeclaration());
        }
        while (mods != null || this.S.token() != Tokens.EOF) {
            defs.append(this.typeDeclaration(mods));
            mods = null;
        }
        Tree.TopLevel toplevel = this.F.at(pos).TopLevel(packageAnnotations, pid, defs.toList());
        this.attach(toplevel, dc);
        if (defs.elems.isEmpty()) {
            this.storeEnd(toplevel, this.S.prevEndPos());
        }
        if (this.keepDocComments) {
            toplevel.docComments = this.docComments;
        }
        if (this.genEndPos) {
            toplevel.endPositions = this.endPositions;
        }
        return toplevel;
    }

    Tree importDeclaration() {
        int pos = this.S.pos();
        this.S.nextToken();
        boolean importStatic = false;
        if (this.S.token() == Tokens.STATIC) {
            this.checkStaticImports();
            importStatic = true;
            this.S.nextToken();
        }
        Tree pid = this.F.at(this.S.pos()).Ident(this.ident());
        this.storeEnd(pid, this.S.prevEndPos());
        do {
            int pos1 = this.S.pos();
            this.accept(Tokens.DOT);
            if (this.S.token() == Tokens.STAR) {
                pid = this.F.at(pos1).Select(pid, this.names.asterisk);
                this.storeEnd(pid, this.S.endPos());
                this.S.nextToken();
                break;
            }
            pid = this.F.at(pos1).Select(pid, this.ident());
            this.storeEnd(pid, this.S.prevEndPos());
        } while (this.S.token() == Tokens.DOT);
        this.accept(Tokens.SEMI);
        pid = this.F.at(pos).Import(pid, importStatic);
        this.storeEnd(pid, this.S.prevEndPos());
        return pid;
    }

    Tree typeDeclaration(Tree.Modifiers mods) {
        if (this.S.pos() == this.S.errPos()) {
            this.modifiersOpt();
            while (!(this.S.token() == Tokens.CLASS || this.S.token() == Tokens.INTERFACE || this.allowEnums && this.S.token() == Tokens.ENUM || this.S.token() == Tokens.EOF)) {
                this.S.nextToken();
                this.modifiersOpt();
            }
        }
        int pos = this.S.pos();
        if (mods == null && this.S.token() == Tokens.SEMI) {
            Tree.Skip t = this.F.at(pos).Skip();
            this.storeEnd(t, this.S.endPos());
            this.S.nextToken();
            return t;
        }
        String dc = this.S.docComment();
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(mods), dc);
    }

    Tree classOrInterfaceOrEnumDeclaration(Tree.Modifiers mods, String dc) {
        if (this.S.token() == Tokens.CLASS) {
            return this.classDeclaration(mods, dc);
        }
        if (this.S.token() == Tokens.INTERFACE) {
            return this.interfaceDeclaration(mods, dc);
        }
        if (this.allowEnums && this.S.token() == Tokens.ENUM) {
            return this.enumDeclaration(mods, dc);
        }
        return this.syntaxError("class.or.intf.expected");
    }

    Tree classDeclaration(Tree.Modifiers mods, String dc) {
        int pos = this.S.pos();
        this.accept(Tokens.CLASS);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        Tree extending = null;
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            extending = this.type();
        }
        List<Tree> implementing = Tree.emptyList;
        if (this.S.token() == Tokens.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<Tree> defs = this.classOrInterfaceBody(name, false);
        Tree.ClassDef result = this.F.at(pos).ClassDef(mods, name, typarams, extending, implementing, defs);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    Tree interfaceDeclaration(Tree.Modifiers mods, String dc) {
        int pos = this.S.pos();
        this.accept(Tokens.INTERFACE);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        List<Tree> extending = Tree.emptyList;
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            extending = this.typeList();
        }
        List<Tree> defs = this.classOrInterfaceBody(name, true);
        Tree.ClassDef result = this.F.at(pos).ClassDef(mods, name, typarams, null, extending, defs);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    Tree enumDeclaration(Tree.Modifiers mods, String dc) {
        int pos = this.S.pos();
        this.accept(Tokens.ENUM);
        mods.flags |= 0x4000L;
        Name name = this.ident();
        List<Tree> implementing = Tree.emptyList;
        if (this.S.token() == Tokens.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<Tree> defs = this.enumBody(name);
        Tree.ClassDef result = this.F.at(pos).ClassDef(mods, name, Tree.TypeParameter.emptyList, null, implementing, defs);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    List<Tree> enumBody(Name enumName) {
        int pos = this.S.pos();
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> defs = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.SEMI) {
            defs.append(this.enumeratorDeclaration(enumName));
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Tokens.RBRACE || this.S.token() == Tokens.SEMI) break;
                defs.append(this.enumeratorDeclaration(enumName));
            }
        }
        if (this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            while (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.EOF) {
                defs.appendList(this.classOrInterfaceBodyDeclaration(enumName, false));
            }
        }
        this.accept(Tokens.RBRACE);
        return defs.toList();
    }

    Tree enumeratorDeclaration(Name enumName) {
        String dc = this.S.docComment();
        int pos = this.S.pos();
        List<Tree.Annotation> annotations = this.annotationsOpt();
        Tree.Modifiers mods = this.F.at(annotations.isEmpty() ? -1 : pos).Modifiers(16409L, annotations);
        List<Tree> typeArgs = this.typeArgumentsOpt();
        Name name = this.ident();
        int createPos = this.S.pos();
        List<Tree> args = this.S.token() == Tokens.LPAREN ? this.arguments() : Tree.emptyList;
        Tree.ClassDef body = this.S.token() != Tokens.LBRACE ? null : this.F.at(this.S.pos()).ClassDef(this.F.Modifiers(16392L), this.names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, this.classOrInterfaceBody(this.names.empty, false));
        this.storeEnd(body, this.S.prevEndPos());
        if (args.isEmpty() && body == null) {
            createPos = -1;
        }
        Tree.NewClass create = this.F.at(createPos).NewClass(null, typeArgs, this.F.at(-1).Ident(enumName), args, body);
        if (createPos != -1) {
            this.storeEnd(create, this.S.prevEndPos());
        }
        Tree.Ident ident = this.F.at(-1).Ident(enumName);
        Tree.VarDef result = this.F.at(pos).VarDef(mods, name, ident, create);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    List<Tree> typeList() {
        ListBuffer<Tree> ts = new ListBuffer<Tree>();
        ts.append(this.type());
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            ts.append(this.type());
        }
        return ts.toList();
    }

    List<Tree> classOrInterfaceBody(Name className, boolean isInterface) {
        int pos = this.S.pos();
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> defs = new ListBuffer<Tree>();
        while (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.EOF) {
            defs.appendList(this.classOrInterfaceBodyDeclaration(className, isInterface));
        }
        this.accept(Tokens.RBRACE);
        return defs.toList();
    }

    List<Tree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        Tree type;
        boolean isVoid;
        int pos = this.S.pos();
        if (this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            return Tree.emptyList.prepend(this.F.at(-1).Block(0L, Tree.emptyList));
        }
        String dc = this.S.docComment();
        pos = this.S.pos();
        Tree.Modifiers mods = this.modifiersOpt();
        if (this.S.token() == Tokens.CLASS || this.S.token() == Tokens.INTERFACE || this.allowEnums && this.S.token() == Tokens.ENUM) {
            return Tree.emptyList.prepend(this.classOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.S.token() == Tokens.LBRACE && !isInterface && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            return Tree.emptyList.prepend(this.block(pos, mods.flags));
        }
        pos = this.S.pos();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        if (typarams.length() > 0 && mods.pos == -1) {
            mods.pos = pos;
        }
        Tokens token = this.S.token();
        Name name = this.S.name();
        pos = this.S.pos();
        boolean bl = isVoid = this.S.token() == Tokens.VOID;
        if (isVoid) {
            type = this.F.at(pos).TypeIdent(9);
            this.storeEnd(type, this.S.endPos());
            this.S.nextToken();
        } else {
            type = this.type();
        }
        if (this.S.token() == Tokens.LPAREN && !isInterface && type.tag == 35) {
            if (isInterface || name != className) {
                this.log.error(pos, "invalid.meth.decl.ret.type.req", new Object[0]);
            }
            return Tree.emptyList.prepend(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, dc));
        }
        pos = this.S.pos();
        name = this.ident();
        if (this.S.token() == Tokens.LPAREN) {
            return Tree.emptyList.prepend(this.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<Tree> defs = this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc);
            this.storeEnd(defs.last(), this.S.endPos());
            this.accept(Tokens.SEMI);
            return defs;
        }
        this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
        return Tree.emptyList;
    }

    Tree methodDeclaratorRest(int pos, Tree.Modifiers mods, Tree type, Name name, List<Tree.TypeParameter> typarams, boolean isInterface, boolean isVoid, String dc) {
        Tree defaultValue;
        Tree.Block body;
        List<Tree.VarDef> params = this.formalParameters();
        if (!isVoid) {
            type = this.bracketsOpt(type);
        }
        List<Tree> thrown = Tree.emptyList;
        if (this.S.token() == Tokens.THROWS) {
            this.S.nextToken();
            thrown = this.qualidentList();
        }
        if (this.S.token() == Tokens.LBRACE) {
            body = this.block();
            defaultValue = null;
        } else {
            if (this.S.token() == Tokens.DEFAULT) {
                this.accept(Tokens.DEFAULT);
                defaultValue = this.annotationValue();
            } else {
                defaultValue = null;
            }
            this.accept(Tokens.SEMI);
            body = null;
        }
        Tree.MethodDef result = this.F.at(pos).MethodDef(mods, name, type, typarams, params, thrown, body, defaultValue);
        this.storeEnd(result, this.S.prevEndPos());
        this.attach(result, dc);
        return result;
    }

    List<Tree> qualidentList() {
        ListBuffer<Tree> ts = new ListBuffer<Tree>();
        ts.append(this.qualident());
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            ts.append(this.qualident());
        }
        return ts.toList();
    }

    List<Tree.TypeParameter> typeParametersOpt() {
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            ListBuffer<Tree.TypeParameter> typarams = new ListBuffer<Tree.TypeParameter>();
            this.S.nextToken();
            typarams.append(this.typeParameter());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                typarams.append(this.typeParameter());
            }
            this.accept(Tokens.GT);
            return typarams.toList();
        }
        return Tree.TypeParameter.emptyList;
    }

    Tree.TypeParameter typeParameter() {
        int pos = this.S.pos();
        Name name = this.ident();
        ListBuffer<Tree> bounds = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            bounds.append(this.type());
            while (this.S.token() == Tokens.AMP) {
                this.S.nextToken();
                bounds.append(this.type());
            }
        }
        Tree.TypeParameter t = this.F.at(pos).TypeParameter(name, bounds.toList());
        this.storeEnd(t, this.S.prevEndPos());
        return t;
    }

    List<Tree.VarDef> formalParameters() {
        ListBuffer<Tree.VarDef> params = new ListBuffer<Tree.VarDef>();
        Tree.VarDef lastParam = null;
        this.accept(Tokens.LPAREN);
        if (this.S.token() != Tokens.RPAREN) {
            lastParam = this.formalParameter();
            params.append(lastParam);
            while ((lastParam.mods.flags & 0x400000000L) == 0L && this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                lastParam = this.formalParameter();
                params.append(lastParam);
            }
        }
        this.accept(Tokens.RPAREN);
        return params.toList();
    }

    Tree.Modifiers optFinal(long flags) {
        Tree.Modifiers mods = this.modifiersOpt();
        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFEFL);
        mods.flags |= flags;
        return mods;
    }

    Tree.VarDef formalParameter() {
        Tree.Modifiers mods = this.optFinal(0x200000000L);
        Tree type = this.type();
        if (this.S.token() == Tokens.ELLIPSIS) {
            this.checkVarargs();
            mods.flags |= 0x400000000L;
            type = this.F.at(this.S.pos()).TypeArray(type);
            this.storeEnd(type, this.S.endPos());
            this.S.nextToken();
        }
        return this.variableDeclaratorId(mods, type);
    }

    private List<Tree> makeList(Tree a, Tree b) {
        return new List<Tree>(a, new List<Tree>(b, Tree.emptyList));
    }

    private List<Tree> makeList(Tree a) {
        return new List<Tree>(a, Tree.emptyList);
    }

    protected Tree checkExprStat(Tree t) {
        switch (t.tag) {
            case 26: 
            case 27: 
            case 30: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return t;
            }
        }
        this.log.error(t.pos, "not.stmt", new Object[0]);
        return this.F.at(t.pos).Erroneous();
    }

    static int prec(Tokens token) {
        int oc = Parser.optag(token);
        return oc >= 0 ? TreeInfo.opPrec(oc) : -1;
    }

    static long lowestOneBit(long i) {
        return i & -i;
    }

    static int optag(Tokens token) {
        switch (token) {
            case BARBAR: {
                return 55;
            }
            case AMPAMP: {
                return 56;
            }
            case BAR: {
                return 57;
            }
            case BAREQ: {
                return 74;
            }
            case CARET: {
                return 58;
            }
            case CARETEQ: {
                return 75;
            }
            case AMP: {
                return 59;
            }
            case AMPEQ: {
                return 76;
            }
            case EQEQ: {
                return 60;
            }
            case BANGEQ: {
                return 61;
            }
            case LT: {
                return 62;
            }
            case GT: {
                return 63;
            }
            case LTEQ: {
                return 64;
            }
            case GTEQ: {
                return 65;
            }
            case LTLT: {
                return 66;
            }
            case LTLTEQ: {
                return 83;
            }
            case GTGT: {
                return 67;
            }
            case GTGTEQ: {
                return 84;
            }
            case GTGTGT: {
                return 68;
            }
            case GTGTGTEQ: {
                return 85;
            }
            case PLUS: {
                return 69;
            }
            case PLUSEQ: {
                return 86;
            }
            case SUB: {
                return 70;
            }
            case SUBEQ: {
                return 87;
            }
            case STAR: {
                return 71;
            }
            case STAREQ: {
                return 88;
            }
            case SLASH: {
                return 72;
            }
            case SLASHEQ: {
                return 89;
            }
            case PERCENT: {
                return 73;
            }
            case PERCENTEQ: {
                return 90;
            }
            case INSTANCEOF: {
                return 32;
            }
        }
        return -1;
    }

    static int unoptag(Tokens token) {
        switch (token) {
            case PLUS: {
                return 46;
            }
            case SUB: {
                return 47;
            }
            case BANG: {
                return 48;
            }
            case TILDE: {
                return 49;
            }
            case PLUSPLUS: {
                return 50;
            }
            case SUBSUB: {
                return 51;
            }
        }
        return -1;
    }

    static int typetag(Tokens token) {
        switch (token) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BOOLEAN: {
                return 8;
            }
        }
        return -1;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.log.error(this.S.pos(), "generics.not.supported.in.source", new Object[]{this.source.name});
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.log.error(this.S.pos(), "varargs.not.supported.in.source", new Object[]{this.source.name});
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.log.error(this.S.pos(), "foreach.not.supported.in.source", new Object[]{this.source.name});
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.log.error(this.S.pos(), "static.import.not.supported.in.source", new Object[]{this.source.name});
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.log.error(this.S.pos(), "annotations.not.supported.in.source", new Object[]{this.source.name});
            this.allowAnnotations = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $SwitchMap$com$sun$tools$javac$parser$Tokens = new int[Tokens.values().length];
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EOF.ordinal()] = 1;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CLASS.ordinal()] = 2;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INTERFACE.ordinal()] = 3;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ENUM.ordinal()] = 4;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SEMI.ordinal()] = 5;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RBRACE.ordinal()] = 6;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RPAREN.ordinal()] = 7;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LBRACE.ordinal()] = 8;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LPAREN.ordinal()] = 9;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INTLITERAL.ordinal()] = 10;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LONGLITERAL.ordinal()] = 11;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FLOATLITERAL.ordinal()] = 12;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOUBLELITERAL.ordinal()] = 13;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CHARLITERAL.ordinal()] = 14;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STRINGLITERAL.ordinal()] = 15;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRUE.ordinal()] = 16;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FALSE.ordinal()] = 17;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NULL.ordinal()] = 18;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EQ.ordinal()] = 19;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUSEQ.ordinal()] = 20;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUBEQ.ordinal()] = 21;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STAREQ.ordinal()] = 22;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SLASHEQ.ordinal()] = 23;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PERCENTEQ.ordinal()] = 24;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMPEQ.ordinal()] = 25;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BAREQ.ordinal()] = 26;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CARETEQ.ordinal()] = 27;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTLTEQ.ordinal()] = 28;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTEQ.ordinal()] = 29;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTGTEQ.ordinal()] = 30;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BANG.ordinal()] = 31;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TILDE.ordinal()] = 32;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.THIS.ordinal()] = 33;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUPER.ordinal()] = 34;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NEW.ordinal()] = 35;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IDENTIFIER.ordinal()] = 36;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ASSERT.ordinal()] = 37;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BYTE.ordinal()] = 38;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SHORT.ordinal()] = 39;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CHAR.ordinal()] = 40;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INT.ordinal()] = 41;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LONG.ordinal()] = 42;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FLOAT.ordinal()] = 43;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOUBLE.ordinal()] = 44;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BOOLEAN.ordinal()] = 45;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.VOID.ordinal()] = 46;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LBRACKET.ordinal()] = 47;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOT.ordinal()] = 48;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.QUES.ordinal()] = 49;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUSPLUS.ordinal()] = 50;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUBSUB.ordinal()] = 51;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUS.ordinal()] = 52;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUB.ordinal()] = 53;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTEQ.ordinal()] = 54;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTGT.ordinal()] = 55;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGT.ordinal()] = 56;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CASE.ordinal()] = 57;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DEFAULT.ordinal()] = 58;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IF.ordinal()] = 59;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FOR.ordinal()] = 60;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.WHILE.ordinal()] = 61;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DO.ordinal()] = 62;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRY.ordinal()] = 63;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SWITCH.ordinal()] = 64;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SYNCHRONIZED.ordinal()] = 65;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RETURN.ordinal()] = 66;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.THROW.ordinal()] = 67;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BREAK.ordinal()] = 68;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CONTINUE.ordinal()] = 69;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ELSE.ordinal()] = 70;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FINALLY.ordinal()] = 71;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CATCH.ordinal()] = 72;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.MONKEYS_AT.ordinal()] = 73;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FINAL.ordinal()] = 74;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ABSTRACT.ordinal()] = 75;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STRICTFP.ordinal()] = 76;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PRIVATE.ordinal()] = 77;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PROTECTED.ordinal()] = 78;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PUBLIC.ordinal()] = 79;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STATIC.ordinal()] = 80;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRANSIENT.ordinal()] = 81;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NATIVE.ordinal()] = 82;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.VOLATILE.ordinal()] = 83;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BARBAR.ordinal()] = 84;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMPAMP.ordinal()] = 85;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BAR.ordinal()] = 86;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CARET.ordinal()] = 87;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMP.ordinal()] = 88;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EQEQ.ordinal()] = 89;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BANGEQ.ordinal()] = 90;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LT.ordinal()] = 91;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GT.ordinal()] = 92;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTEQ.ordinal()] = 93;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTLT.ordinal()] = 94;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STAR.ordinal()] = 95;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SLASH.ordinal()] = 96;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PERCENT.ordinal()] = 97;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            Parser.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INSTANCEOF.ordinal()] = 98;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        $assertionsDisabled = !(class$com$sun$tools$javac$parser$Parser == null ? (class$com$sun$tools$javac$parser$Parser = Parser.class$("com.sun.tools.javac.parser.Parser")) : class$com$sun$tools$javac$parser$Parser).desiredAssertionStatus();
        errorTree = new Tree.Erroneous();
        emptyStringList = new List();
    }

    public static class Factory {
        protected static final Context.Key<Factory> parserFactoryKey = new Context.Key();
        final TreeMaker F;
        final Log log;
        final Keywords keywords;
        final Source source;
        final Name.Table names;
        final Options options;

        public static Factory instance(Context context) {
            Factory instance = context.get(parserFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(parserFactoryKey, this);
            this.F = TreeMaker.instance(context);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.keywords = Keywords.instance(context);
            this.source = Source.instance(context);
            this.options = Options.instance(context);
        }

        public Parser newParser(Scanner S, boolean keepDocComments) {
            return new Parser(this, S, keepDocComments);
        }
    }
}

