/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.netbeans.lib.gjast.ASClassReader;
import org.netbeans.lib.gjast.ASLog;
import org.netbeans.lib.gjast.ASParser;
import org.netbeans.lib.java.parser.CompilerException;
import org.netbeans.lib.java.parser.ECRequestDesc;
import org.netbeans.lib.java.parser.ErrorChecker;
import org.openide.ErrorManager;

public class ASErrorChecker
implements ErrorChecker,
ClassReader.SourceCompleter {
    private Context context;
    private ASLog log;
    private Enter enter;
    private Flow flow;
    private Name.Table names;
    private TreeMaker make;
    private Scanner.Factory scannerFactory;
    private Parser.Factory parserFactory;
    private ECRequestDesc request;
    private static final boolean debug = Boolean.getBoolean("perf.gjast");
    private static final boolean debugPaths = Boolean.getBoolean("gjast.debug.paths");

    public ASErrorChecker(ECRequestDesc desc) {
        this.request = desc;
    }

    public int parse() throws CompilerException {
        Reader in = null;
        long start = System.currentTimeMillis();
        String filename = this.request.getFileName();
        if (!filename.endsWith(".java")) {
            filename = filename + ".java";
        }
        if (debug) {
            System.err.println("ASErrorChecker parsing " + filename);
        }
        try {
            in = this.request.getReader();
            this.compile(filename, in);
            int n = this.log.nerrors;
            return n;
        }
        catch (Throwable t) {
            throw new CompilerException(t);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            this.release();
            if (debug) {
                long time = System.currentTimeMillis() - start;
                System.err.println("ASErrorChecker parsed " + filename + " in " + time + " ms.");
            }
        }
    }

    private static String dumpECRequestDesc(ECRequestDesc desc) {
        StringBuffer sb = new StringBuffer("ECRequestDesc: ");
        sb.append(desc);
        sb.append("\n\tfilename=\"");
        sb.append(desc.getFileName());
        sb.append("\"\n\tbootclasspath=\"");
        sb.append(desc.getBootClassPath());
        sb.append("\"\n\tsourceclasspath=\"");
        sb.append(desc.getSourceClassPath());
        sb.append("\"\n\tclasspath=\"");
        sb.append(desc.getClassPath());
        sb.append("\"\n\tsourcelevel=\"");
        sb.append(desc.getSourceLevel());
        sb.append("\"");
        return sb.toString();
    }

    private void release() {
        ASClassReader reader = (ASClassReader)ClassReader.instance(this.context);
        reader.sourceCompleter = null;
        reader.setECRequestDesc(null);
        this.log = null;
        this.enter = null;
        this.flow = null;
        this.make = null;
        this.scannerFactory = null;
        this.parserFactory = null;
        this.names = null;
        this.request = null;
        this.context = null;
    }

    public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
        if (debug) {
            System.err.println("ASErrorChecker completing " + c);
        }
        InputStreamReader source = new InputStreamReader(f);
        Tree.TopLevel tree = this.parse(filename, source);
        this.enter.complete(List.make(tree), c);
        if (this.enter.getEnv(c) == null) {
            String msg = ASLog.getLocalizedString("file.doesnt.contain.class", new Object[]{c.fullname});
            throw new ClassReader.BadClassFile(c, filename, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compile(String filename, Reader in) throws Throwable {
        this.context = new Context();
        ASClassReader.register(this.context);
        ASLog.register(this.context);
        Options opts = Options.instance(this.context);
        opts.put("-Xlint:deprecation", "true");
        opts.put("-source", this.request.getSourceLevel());
        opts.put("-target", this.request.getSourceLevel());
        String cp = this.request.getBootClassPath();
        if (cp != null) {
            opts.put("-bootclasspath", cp);
            if (debugPaths) {
                System.err.println("ASErrorChecker bootclasspath=" + cp);
            }
        }
        cp = this.request.getClassPath();
        opts.put("-classpath", cp);
        if (debugPaths) {
            System.err.println("ASErrorChecker classpath=" + cp);
        }
        if ((cp = this.request.getSourceClassPath()) != null) {
            opts.put("-sourcepath", cp);
            if (debugPaths) {
                System.err.println("ASErrorChecker sourceclasspath=" + cp);
            }
        }
        this.log = ASLog.instance(this.context);
        this.log.errConsumer(this.request.getErrConsumer());
        this.make = TreeMaker.instance(this.context);
        this.scannerFactory = Scanner.Factory.instance(this.context);
        this.parserFactory = Parser.Factory.instance(this.context);
        this.names = Name.Table.instance(this.context);
        this.enter = Enter.instance(this.context);
        this.flow = Flow.instance(this.context);
        Attr attr = Attr.instance(this.context);
        Todo todo = Todo.instance(this.context);
        ASClassReader reader = (ASClassReader)ClassReader.instance(this.context);
        reader.sourceCompleter = this;
        reader.setECRequestDesc(this.request);
        try {
            Tree.TopLevel topLevel = this.parse(filename, in);
            if (this.log.nerrors == 0) {
                this.enter.main(List.make(topLevel));
                while (todo.nonEmpty()) {
                    Env env = (Env)todo.next();
                    if (env.toplevel != topLevel) continue;
                    this.log.useSource(topLevel.sourcefile);
                    attr.attribClass(env.tree.pos, env.enclClass.sym);
                    if (this.log.nerrors != 0) continue;
                    this.make.at(0);
                    TreeMaker localMake = this.make.forToplevel(env.toplevel);
                    this.flow.analyzeTree(env.tree, localMake);
                }
            }
        }
        finally {
            this.log.releaseSources();
            reader.close();
            this.names.dispose();
        }
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    protected Tree.TopLevel parse(String filename, Reader input) {
        Name sourceName = this.names.fromString(filename);
        Name prev = this.log.useSource(sourceName);
        Tree.TopLevel tree = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
        if (input != null) {
            char[] src = ASParser.readInChars(input);
            this.log.addSource(sourceName, src);
            Scanner scanner = this.scannerFactory.newScanner(src, src.length - 1);
            Parser parser = this.parserFactory.newParser(scanner, false);
            tree = parser.compilationUnit();
        }
        this.log.useSource(prev);
        tree.sourcefile = sourceName;
        return tree;
    }
}

