/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.EmacsRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.IDEAJRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;

public class CommandLineOptions {
    private boolean debugEnabled;
    private boolean jdk13;
    private boolean shortNamesEnabled;
    private String inputFileName;
    private String reportFormat;
    private String ruleSets;
    private String[] args;

    public CommandLineOptions(String[] args) {
        if (args == null || args.length < 3) {
            throw new RuntimeException(this.usage());
        }
        this.inputFileName = args[0];
        this.reportFormat = args[1];
        this.ruleSets = args[2];
        this.args = args;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-debug")) {
                this.debugEnabled = true;
            } else if (args[i].equals("-shortnames")) {
                this.shortNamesEnabled = true;
            } else if (args[i].equals("-jdk13")) {
                this.jdk13 = true;
            }
            ++i;
        }
    }

    public Renderer createRenderer() {
        if (this.reportFormat.equals("xml")) {
            return new XMLRenderer();
        }
        if (this.reportFormat.equals("ideaj")) {
            return new IDEAJRenderer(this.args);
        }
        if (this.reportFormat.equals("text")) {
            return new TextRenderer();
        }
        if (this.reportFormat.equals("emacs")) {
            return new EmacsRenderer();
        }
        if (this.reportFormat.equals("csv")) {
            return new CSVRenderer();
        }
        if (this.reportFormat.equals("html")) {
            return new HTMLRenderer();
        }
        if (!this.reportFormat.equals("")) {
            try {
                return (Renderer)Class.forName(this.reportFormat).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't find the custom format " + this.reportFormat + ": " + e.getClass().getName());
            }
        }
        throw new IllegalArgumentException("Can't create report with format of " + this.reportFormat);
    }

    public boolean containsCommaSeparatedFileList() {
        return this.inputFileName.indexOf(44) != -1;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getRulesets() {
        return this.ruleSets;
    }

    public boolean debugEnabled() {
        return this.debugEnabled;
    }

    public boolean jdk13() {
        return this.jdk13;
    }

    public boolean shortNamesEnabled() {
        return this.shortNamesEnabled;
    }

    public String usage() {
        return PMD.EOL + PMD.EOL + "Mandatory arguments:" + PMD.EOL + "1) A java source code filename or directory" + PMD.EOL + "2) A report format " + PMD.EOL + "3) A ruleset filename or a comma-delimited string of ruleset filenames" + PMD.EOL + PMD.EOL + "For example: " + PMD.EOL + "c:\\> java -jar pmd-1.3.jar c:\\my\\source\\code html rulesets/unusedcode.xml,rulesets/imports.xml" + PMD.EOL + PMD.EOL + "Optional arguments that may be put after the mandatory arguments are: " + PMD.EOL + "-debug: prints debugging information " + PMD.EOL + "-jdk13: enables PMD to parse source code written using 'assert' as an identifier" + PMD.EOL + "-shortnames: prints shortened filenames in the report" + PMD.EOL + PMD.EOL + "For example: " + PMD.EOL + "c:\\> java -jar pmd-1.3.jar c:\\my\\source\\code html rulesets/unusedcode.xml,rulesets/imports.xml -jdk13 -debug" + PMD.EOL + PMD.EOL;
    }
}

