/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.stat.Metric;

public class Report {
    private Set violations = new TreeSet(new RuleViolation.RuleViolationComparator());
    private Set metrics = new HashSet();
    private List listeners = new ArrayList();
    private List errors = new ArrayList();

    public void addListener(ReportListener listener) {
        this.listeners.add(listener);
    }

    public void addRuleViolation(RuleViolation violation) {
        this.violations.add(violation);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.metricAdded(metric);
        }
    }

    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return this.violations.isEmpty();
    }

    public Iterator iterator() {
        return this.violations.iterator();
    }

    public Iterator errors() {
        return this.errors.iterator();
    }

    public int size() {
        return this.violations.size();
    }

    public static class ProcessingError {
        private String msg;
        private String file;

        public ProcessingError(String msg, String file) {
            this.msg = msg;
            this.file = file;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getFile() {
            return this.file;
        }
    }
}

