/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Comparator;
import java.util.List;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.TokenEntry;

public class MarkComparator
implements Comparator {
    private final int comparisonUpdateInterval;
    private CPDListener l;
    private long comparisons;
    private List tokens;

    public MarkComparator(CPDListener l, List tokens) {
        this(l, tokens, 10000);
    }

    public MarkComparator(CPDListener l, List tokens, int comparisonUpdateInterval) {
        this.l = l;
        this.tokens = tokens;
        this.comparisonUpdateInterval = comparisonUpdateInterval;
    }

    public int compare(Object o1, Object o2) {
        ++this.comparisons;
        if (this.comparisons % (long)this.comparisonUpdateInterval == 0L) {
            this.l.comparisonCountUpdate(this.comparisons);
        }
        Mark mark1 = (Mark)o1;
        Mark mark2 = (Mark)o2;
        int i = 1;
        while (i < this.tokens.size()) {
            int cmp = this.tokenAt(i, mark1).compareTo(this.tokenAt(i, mark2));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public TokenEntry tokenAt(int index, Mark mark) {
        return (TokenEntry)this.tokens.get((index + mark.getIndexIntoTokenArray()) % this.tokens.size());
    }
}

