/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.MarkComparator;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;

public class MatchCollector {
    private List marks;
    private MarkComparator markComparator;

    public MatchCollector(List marks, MarkComparator mc) {
        this.marks = marks;
        this.markComparator = mc;
    }

    public List collect(int minimumLength) {
        ArrayList<Match> matches = new ArrayList<Match>();
        HashSet<String> filesUsedSoFar = new HashSet<String>();
        int i = 1;
        while (i < this.marks.size()) {
            int dupes;
            Mark mark1 = (Mark)this.marks.get(i);
            Mark mark2 = (Mark)this.marks.get(i - 1);
            if (!filesUsedSoFar.contains(mark1.getTokenSrcID()) && !filesUsedSoFar.contains(mark2.getTokenSrcID()) && (dupes = this.countDuplicateTokens(mark1, mark2)) >= minimumLength) {
                filesUsedSoFar.add(mark1.getTokenSrcID());
                filesUsedSoFar.add(mark2.getTokenSrcID());
                Match match = new Match(dupes, mark1, mark2);
                matches.add(match);
            }
            ++i;
        }
        return matches;
    }

    private int countDuplicateTokens(Mark mark1, Mark mark2) {
        int index = 0;
        while (!this.matchEnded(this.markComparator.tokenAt(index, mark1), this.markComparator.tokenAt(index, mark2))) {
            ++index;
        }
        return index;
    }

    private boolean matchEnded(TokenEntry token1, TokenEntry token2) {
        return !token1.equals(token2) || token1 == TokenEntry.EOF || token2 == TokenEntry.EOF;
    }
}

