/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class XMLRenderer
implements Renderer {
    public String render(Iterator matches) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>");
        buffer.append("<pmd-cpd>");
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            buffer.append("<duplication");
            buffer.append(" lines=\"");
            buffer.append(match.getLineCount());
            buffer.append("\"");
            buffer.append(" tokens=\"");
            buffer.append(match.getTokenCount());
            buffer.append("\">");
            Iterator iterator = match.iterator();
            while (iterator.hasNext()) {
                Mark mark = (Mark)iterator.next();
                buffer.append("<file");
                buffer.append(" line=\"");
                buffer.append(mark.getBeginLine());
                buffer.append("\"");
                buffer.append(" path=\"");
                buffer.append(mark.getTokenSrcID());
                buffer.append("\"/>");
            }
            String codeFragment = match.getSourceCodeSlice();
            if (codeFragment != null) {
                buffer.append("<codefragment><![CDATA[" + PMD.EOL + StringUtil.replaceString(codeFragment, "]]>", "]]&gt;") + PMD.EOL + "]]></codefragment>");
            }
            buffer.append("</duplication>");
        }
        buffer.append("</pmd-cpd>");
        return buffer.toString();
    }
}

