/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jaxen;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sourceforge.pmd.ast.Node;

public abstract class NodeIterator
implements Iterator {
    private Node node;

    public NodeIterator(Node contextNode) {
        this.node = this.getFirstNode(contextNode);
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Node ret = this.node;
        this.node = this.getNextNode(this.node);
        return ret;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract Node getFirstNode(Node var1);

    protected abstract Node getNextNode(Node var1);

    protected Node getPreviousSibling(Node contextNode) {
        int prevPosition;
        Node parentNode = contextNode.jjtGetParent();
        if (parentNode != null && (prevPosition = this.getPositionFromParent(contextNode) - 1) >= 0) {
            return parentNode.jjtGetChild(prevPosition);
        }
        return null;
    }

    private int getPositionFromParent(Node contextNode) {
        Node parentNode = contextNode.jjtGetParent();
        int i = 0;
        while (i < parentNode.jjtGetNumChildren()) {
            if (parentNode.jjtGetChild(i) == contextNode) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Node was not a child of it's parent ???");
    }

    protected Node getNextSibling(Node contextNode) {
        int nextPosition;
        Node parentNode = contextNode.jjtGetParent();
        if (parentNode != null && (nextPosition = this.getPositionFromParent(contextNode) + 1) < parentNode.jjtGetNumChildren()) {
            return parentNode.jjtGetChild(nextPosition);
        }
        return null;
    }

    protected Node getFirstChild(Node contextNode) {
        if (contextNode.jjtGetNumChildren() > 0) {
            return contextNode.jjtGetChild(0);
        }
        return null;
    }

    protected Node getLastChild(Node contextNode) {
        if (contextNode.jjtGetNumChildren() > 0) {
            return contextNode.jjtGetChild(contextNode.jjtGetNumChildren() - 1);
        }
        return null;
    }
}

