/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.rules.ImportWrapper;

public class UnusedImportsRule
extends AbstractRule {
    private Set imports = new HashSet();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        super.visit(node, data);
        RuleContext ctx = (RuleContext)data;
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            ImportWrapper wrapper = (ImportWrapper)i.next();
            String msg = MessageFormat.format(this.getMessage(), wrapper.getName());
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, wrapper.getLine(), msg));
        }
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        if (!node.isImportOnDemand()) {
            String className;
            ASTName importedType = (ASTName)node.jjtGetChild(0);
            if (importedType.getImage().indexOf(46) != -1) {
                int lastDot = importedType.getImage().lastIndexOf(46) + 1;
                className = importedType.getImage().substring(lastDot);
            } else {
                className = importedType.getImage();
            }
            ImportWrapper wrapper = new ImportWrapper(className, node.getBeginLine());
            this.imports.add(wrapper);
        }
        return data;
    }

    public Object visit(ASTName node, Object data) {
        String name = node.getImage().indexOf(46) == -1 ? node.getImage() : node.getImage().substring(0, node.getImage().indexOf(46));
        ImportWrapper candidate = new ImportWrapper(name, -1);
        if (this.imports.contains(candidate)) {
            this.imports.remove(candidate);
        }
        return data;
    }
}

