/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTClassBody;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.SimpleNode;

public class UnusedPrivateMethodRule
extends AbstractRule {
    private Set privateMethodNodes = new HashSet();
    private boolean trollingForDeclarations;
    private int depth;

    public Object visit(ASTInterfaceDeclaration node, Object data) {
        return data;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.depth = 0;
        super.visit(node, data);
        this.privateMethodNodes.clear();
        this.depth = 0;
        this.trollingForDeclarations = false;
        return data;
    }

    public Object visit(ASTClassBody node, Object data) {
        ++this.depth;
        if (this.depth == 1) {
            this.trollingForDeclarations = true;
            super.visit(node, null);
            this.trollingForDeclarations = false;
        } else {
            this.trollingForDeclarations = false;
        }
        super.visit(node, null);
        if (this.depth == 1) {
            RuleContext ctx = (RuleContext)data;
            this.harvestUnused(ctx);
        }
        --this.depth;
        return data;
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!this.trollingForDeclarations) {
            return super.visit(node, data);
        }
        AccessNode parent = (AccessNode)node.jjtGetParent();
        if (!parent.isPrivate()) {
            return super.visit(node, data);
        }
        if (node.getImage().equals("readObject") || node.getImage().equals("writeObject") || node.getImage().equals("readResolve") || node.getImage().equals("writeReplace")) {
            return super.visit(node, data);
        }
        this.privateMethodNodes.add(node);
        return super.visit(node, data);
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        if (!this.trollingForDeclarations && node.jjtGetParent() instanceof ASTPrimaryExpression && node.getImage() != null) {
            if (node.jjtGetNumChildren() > 0) {
                ASTArguments args = (ASTArguments)node.jjtGetChild(0);
                this.removeIfUsed(node.getImage(), args.getArgumentCount());
                return super.visit(node, data);
            }
            ASTPrimaryExpression parent = (ASTPrimaryExpression)node.jjtGetParent();
            int pointer = 0;
            while (!parent.jjtGetChild(pointer).equals(node)) {
                ++pointer;
            }
            if (parent.jjtGetNumChildren() <= ++pointer) {
                return super.visit(node, data);
            }
            if (!(parent.jjtGetChild(pointer) instanceof ASTPrimarySuffix)) {
                return super.visit(node, data);
            }
            ASTPrimarySuffix actualMethodNode = (ASTPrimarySuffix)parent.jjtGetChild(pointer);
            if (actualMethodNode.jjtGetNumChildren() == 0 || !(actualMethodNode.jjtGetChild(0) instanceof ASTArguments)) {
                return super.visit(node, data);
            }
            ASTArguments args = (ASTArguments)actualMethodNode.jjtGetChild(0);
            this.removeIfUsed(node.getImage(), args.getArgumentCount());
        }
        return super.visit(node, data);
    }

    public Object visit(ASTName node, Object data) {
        ASTPrimarySuffix primarySuffix;
        ASTPrimaryExpression primaryExpression;
        if (!this.trollingForDeclarations && node.jjtGetParent() instanceof ASTPrimaryPrefix && (primaryExpression = (ASTPrimaryExpression)node.jjtGetParent().jjtGetParent()).jjtGetNumChildren() > 1 && (primarySuffix = (ASTPrimarySuffix)primaryExpression.jjtGetChild(1)).jjtGetNumChildren() > 0 && primarySuffix.jjtGetChild(0) instanceof ASTArguments) {
            ASTArguments arguments = (ASTArguments)primarySuffix.jjtGetChild(0);
            this.removeIfUsed(node.getImage(), arguments.getArgumentCount());
        }
        return super.visit(node, data);
    }

    private void removeIfUsed(String nodeImage, int args) {
        String img = nodeImage.indexOf(46) == -1 ? nodeImage : nodeImage.substring(nodeImage.indexOf(46) + 1, nodeImage.length());
        Iterator i = this.privateMethodNodes.iterator();
        while (i.hasNext()) {
            ASTMethodDeclarator methodNode = (ASTMethodDeclarator)i.next();
            if (!methodNode.getImage().equals(img) || methodNode.getParameterCount() != args) continue;
            i.remove();
        }
    }

    private void harvestUnused(RuleContext ctx) {
        Iterator i = this.privateMethodNodes.iterator();
        while (i.hasNext()) {
            SimpleNode node = (SimpleNode)i.next();
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, node.getBeginLine(), MessageFormat.format(this.getMessage(), node.getImage())));
        }
    }
}

