/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.StatisticalRule;

public class SwitchDensityRule
extends StatisticalRule {
    public Object visit(ASTSwitchStatement node, Object data) {
        SwitchDensity oldData = null;
        if (data instanceof SwitchDensity) {
            oldData = (SwitchDensity)data;
        }
        SwitchDensity density = new SwitchDensity();
        node.childrenAccept(this, density);
        DataPoint point = new DataPoint();
        point.setLineNumber(node.getBeginLine());
        point.setScore(density.getDensity());
        point.setRule(this);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addStatements(density.getStatementCount());
        }
        return oldData;
    }

    public Object visit(ASTStatement statement, Object data) {
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addStatement();
        }
        statement.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTSwitchLabel switchLabel, Object data) {
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addSwitchLabel();
        }
        switchLabel.childrenAccept(this, data);
        return data;
    }

    private class SwitchDensity {
        private int labels = 0;
        private int stmts = 0;

        public void addSwitchLabel() {
            ++this.labels;
        }

        public void addStatement() {
            ++this.stmts;
        }

        public void addStatements(int stmtCount) {
            this.stmts += stmtCount;
        }

        public int getStatementCount() {
            return this.stmts;
        }

        public double getDensity() {
            if (this.labels == 0) {
                return 0.0;
            }
            return 1.0 * (double)(this.stmts / this.labels);
        }
    }
}

