/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.Stack;
import net.sourceforge.pmd.ast.ASTBlock;
import net.sourceforge.pmd.ast.ASTClassBodyDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration;
import net.sourceforge.pmd.ast.ASTUnmodifiedInterfaceDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ScopeFactory;

public class BasicScopeCreationVisitor
extends JavaParserVisitorAdapter {
    private ScopeFactory sf;
    private Stack scopes = new Stack();

    public BasicScopeCreationVisitor(ScopeFactory sf) {
        this.sf = sf;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTUnmodifiedClassDeclaration node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTClassBodyDeclaration node, Object data) {
        if (node.isAnonymousInnerClass()) {
            this.sf.openScope(this.scopes, node);
            this.cont(node);
        } else {
            super.visit(node, data);
        }
        return data;
    }

    public Object visit(ASTUnmodifiedInterfaceDeclaration node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTBlock node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTTryStatement node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        this.sf.openScope(this.scopes, node);
        this.cont(node);
        return data;
    }

    private void cont(SimpleNode node) {
        super.visit(node, null);
        this.scopes.pop();
    }
}

