/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassScopeEvaluator;
import net.sourceforge.pmd.symboltable.GlobalScope;
import net.sourceforge.pmd.symboltable.GlobalScopeEvaluator;
import net.sourceforge.pmd.symboltable.LocalScopeEvaluator;
import net.sourceforge.pmd.symboltable.MethodScopeEvaluator;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.ScopeEvaluator;
import net.sourceforge.pmd.symboltable.ScopeFactory;

public class BasicScopeFactory
implements ScopeFactory {
    private Set scopeEvaluators = new HashSet();

    public BasicScopeFactory() {
        this.scopeEvaluators.add(new GlobalScopeEvaluator());
        this.scopeEvaluators.add(new ClassScopeEvaluator());
        this.scopeEvaluators.add(new MethodScopeEvaluator());
        this.scopeEvaluators.add(new LocalScopeEvaluator());
    }

    public void openScope(Stack scopes, SimpleNode node) {
        Iterator i = this.scopeEvaluators.iterator();
        while (i.hasNext()) {
            ScopeEvaluator ev = (ScopeEvaluator)i.next();
            if (!ev.isScopeCreatedBy(node)) continue;
            Scope scope = ev.getScopeFor(node);
            if (!(scope instanceof GlobalScope)) {
                scope.setParent((Scope)scopes.peek());
            }
            scopes.add(scope);
            node.setScope((Scope)scopes.peek());
            break;
        }
    }
}

