/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.Applier;

public class ClassScope
extends AbstractScope {
    private static int anonymousInnerClassCounter = 1;
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter = 1;
    }

    public ClassScope() {
        this.className = "Anonymous$" + String.valueOf(anonymousInnerClassCounter);
        ++anonymousInnerClassCounter;
    }

    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void addDeclaration(MethodNameDeclaration decl) {
        this.methodNames.put(decl, new ArrayList());
    }

    protected NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (this.variableNames.isEmpty()) {
                return null;
            }
            return (NameDeclaration)this.variableNames.keySet().iterator().next();
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        return "ClassScope:" + this.className + ":" + super.glomNames();
    }

    private String clipClassName(String in) {
        int firstDot = in.indexOf(46);
        return in.substring(firstDot + 1);
    }
}

