/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.util.viewer.gui.ASTPanel;
import net.sourceforge.pmd.util.viewer.gui.ActionCommands;
import net.sourceforge.pmd.util.viewer.gui.ParseExceptionHandler;
import net.sourceforge.pmd.util.viewer.gui.SourceCodePanel;
import net.sourceforge.pmd.util.viewer.gui.XPathPanel;
import net.sourceforge.pmd.util.viewer.model.ViewerModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import net.sourceforge.pmd.util.viewer.util.NLS;

public class MainFrame
extends JFrame
implements ActionListener,
ActionCommands,
ViewerModelListener {
    private ViewerModel model;
    private SourceCodePanel sourcePanel;
    private ASTPanel astPanel;
    private XPathPanel xPathPanel;
    private JButton compileBtn;
    private JButton evalBtn;

    public MainFrame() {
        super(NLS.nls("MAIN.FRAME.TITLE"));
        this.init();
    }

    private void init() {
        this.model = new ViewerModel();
        this.model.addViewerModelListener(this);
        this.sourcePanel = new SourceCodePanel(this.model);
        this.astPanel = new ASTPanel(this.model);
        this.xPathPanel = new XPathPanel(this.model);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane editingPane = new JSplitPane(1, this.sourcePanel, this.astPanel);
        editingPane.setResizeWeight(0.5);
        JPanel interactionsPane = new JPanel(new BorderLayout());
        interactionsPane.add((Component)this.xPathPanel, "South");
        interactionsPane.add((Component)editingPane, "Center");
        this.getContentPane().add((Component)interactionsPane, "Center");
        this.compileBtn = new JButton(NLS.nls("MAIN.FRAME.COMPILE_BUTTON.TITLE"));
        this.compileBtn.setActionCommand("Compile");
        this.compileBtn.addActionListener(this);
        this.evalBtn = new JButton(NLS.nls("MAIN.FRAME.EVALUATE_BUTTON.TITLE"));
        this.evalBtn.setActionCommand("Evaluate");
        this.evalBtn.addActionListener(this);
        this.evalBtn.setEnabled(false);
        JPanel btnPane = new JPanel(new FlowLayout(0));
        btnPane.add(this.compileBtn);
        btnPane.add(this.evalBtn);
        this.getContentPane().add((Component)btnPane, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        block5: {
            String command;
            block4: {
                command = e.getActionCommand();
                if (!command.equals("Compile")) break block4;
                try {
                    this.model.commitSource(this.sourcePanel.getSourceCode());
                }
                catch (ParseException exc) {
                    new ParseExceptionHandler(this, exc);
                }
                break block5;
            }
            if (!command.equals("Evaluate")) break block5;
            try {
                this.model.evaluateXPathExpression(this.xPathPanel.getXPathExpression(), this);
            }
            catch (Exception exc) {
                new ParseExceptionHandler(this, exc);
            }
        }
    }

    public void viewerModelChanged(ViewerModelEvent e) {
        this.evalBtn.setEnabled(this.model.hasCompiledTree());
    }
}

