/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * VerbosityLevelTestTask.java
 *
 * Created on January 2, 2003, 12:06 PM
 */

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;

/**
 * @author mk97936
 */
public class VerbosityLevelTestTask extends Task {
    
    private String verLevel;
    
    public void setVerlevel(String s) {
        verLevel = s;
    }
    
    public void execute() throws BuildException {
        
        if (verLevel.equalsIgnoreCase("debug")) {
            log("DEBUG message", Project.MSG_DEBUG);
        } else if (verLevel.equalsIgnoreCase("verbose")) {
            log("VERBOSE message", Project.MSG_VERBOSE);
        } else if (verLevel.equalsIgnoreCase("normal")) {
            log("INFO message", Project.MSG_INFO);
        } else if (verLevel.equalsIgnoreCase("err")) {
            log("ERR message", Project.MSG_ERR);
        } else if (verLevel.equalsIgnoreCase("warn")) {
            log("WARN message", Project.MSG_WARN);
        }
        
    }
    
}
