/*
 * RealComplexINumber.java
 *
 * Created on April 18, 2005, 11:09 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package math;

/**
 *   Represents complex number.
 * @author jungi
 */
public class RealComplexINumber implements INumber {
    
    private double a;
    private double b;
    
    /** Creates a new instance of RealComplexINumber */
    public RealComplexINumber() {
        this(0, 0);
    }

    /** Creates a new instance of RealComplexINumber */
    public RealComplexINumber(double real) {
        this(real, 0);
    }

    /**
     *   Creates a new instance of RealComplexINumber
     */
    public RealComplexINumber(double real, double im) {
        a = real;
        b = im;
    }

    /**
     *   u + v = (a + c) + (b + d)i
     */
    public INumber add(INumber no) {
        RealComplexINumber cn = getComplexINumber(no);
        return new RealComplexINumber(a + cn.a, b + cn.b);
    }

    /**
     *   u - v = (a - c) + (b - d)i
     */
    public INumber subtract(INumber no) {
        RealComplexINumber cn = getComplexINumber(no);
        return new RealComplexINumber(a - cn.a, b - cn.b);
    }

    /**
     *   u * v = (ac - bd) + (ad + bc)i
     */
    public INumber multiply(INumber no) {
        RealComplexINumber cn = getComplexINumber(no);
        double rp = a * cn.a - b * cn.b;
        double ip = a * cn.b - b * cn.a;
        return new RealComplexINumber(rp, ip);
    }

    public INumber min(INumber no) {
        throw new UndefinedOperationException();
    }

    public INumber max(INumber no) {
        throw new UndefinedOperationException();
    }

    /**
     *   u / v = u * v.pow(-1)
     */
    public INumber divide(INumber no) {
        RealComplexINumber cn = getComplexINumber(no);
        if (cn.a + cn.b == 0) {
            throw new UndefinedOperationException();
        }
        //return multiply(new Zlomek(cn.sdruzene(), cn.absAsRealNumber()));
        return null;
    }

    /**
     *   -z = -a - bi
     */
    public INumber negate() {
        return new RealComplexINumber(-1 * a, -1 * b);
    }

    public boolean isReal() {
        return b == 0;
    }

    public boolean isDecimal() {
        return false;
    }

    /**
     *   |z| = sqrt(sqr(a) + sqr(b))
     */
    public INumber abs() {
        return new RealComplexINumber(absAsRealNumber(), 0);
    }
    
    public double absAsRealNumber() {
        return Math.hypot(a, b);
    }
    
    public INumber sdruzene() {
        return new RealComplexINumber(a, -1 * b);
    }
    
    public INumber prevracene() {
        double d = absAsRealNumber();
        //return new Zlomek(sdruzene(), d * d);
        return null;
    }
    
    private RealComplexINumber getComplexINumber(INumber no) {
        if (!(no instanceof RealComplexINumber)) {
            throw new UndefinedOperationException();
        }
        return (RealComplexINumber) no;
    }
    
    public String toString() {
        StringBuilder retVal = new StringBuilder(12);
        if (a != 0) {
            if (a > 0) {
                retVal.append(a);
            } else {
                retVal.append(" - ");
                retVal.append(Math.abs(a));
            }
        }
        if (b != 0) {
            retVal.append(" ");
            if (b > 0) {
                if (a != 0) {
                    retVal.append("+ ");
                }
                if (b != 1) {
                    retVal.append(b);
                }
            } else {
                retVal.append("- ");
                if (b != -1) {
                    retVal.append(Math.abs(b));
                }
            }
            retVal.append("i");
        }
        return retVal.toString().trim().replace(".0", "");
    }
    
    public boolean equals(Object obj) {
        boolean retVal = obj instanceof RealComplexINumber;
        if (retVal) {
            RealComplexINumber cn = (RealComplexINumber) obj;
            retVal = (a == cn.a) && (b == cn.b);
        }
        return retVal;
    }
    
    public int hashCode() {
        return (int) (a * 5 + b * 7 + 27);
    }
    

}
