/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.ant.freeform.spi;

import org.openide.util.Lookup;

/**
 * Allows project natures to merge instances of known classes and replace them
 * with single instance.
 * If your contract says that project lookup may contain
 * an implementation of a service and there is possibility that multiple natures
 * will provide implementation of such a service then it is your responsibility
 * to implement LookupMerger which will be capable to merge all these services
 * into one. Implementations of LookupMerger are registered in project's lookup
 * (see {@link ProjectNature#getLookup}).</p>
 * <p class="nonnormative">For example,
 * <a href="@JAVA/API@/org/netbeans/spi/java/classpath/ClassPathProvider.html"><code>ClassPathProvider</code></a>
 * is implemented both by Java nature and Web
 * nature and therefore these impls must be merged and substituted with a single
 * provider. The merger should be implemented by the Java nature.</p>
 * <p>There can be always only one merger for a class. If there is more then
 * one of them the first one will be used and others will be ignored. It is
 * undefined which will be the first one.</p>
 * <p>The base module automatically permits merging of:</p>
 * <dl>
 * <dt>{@link org.netbeans.spi.project.ui.PrivilegedTemplates}</dt>
 * <dd><p>The names of all templates from all providers are merged and returned.</p></dd>
 * <dt>{@link org.netbeans.spi.project.ActionProvider}</dt>
 * <dd><p>Supported actions include all actions supported by any provider. The first provider
 * which claims to support an action is responsible for its enablement and invocation. Note
 * that the base freeform module has an action provider which supports any actions which are
 * bound in <code>project.xml</code> according to the schema, and this provider is always first.</p></dd>
 * </dl>
 * @author David Konecny
 */
public interface LookupMerger {
    
    /**
     * Returns array of base classes which implementations this merger is 
     * capable to merge.
     * @return array of classes
     */
    Class[] getMergeableClasses();
    
    /**
     * Merge instances of the given class in the given lookup and return merged 
     * object which substitutes them.
     * @param lookup lookup with the instances
     * @param clazz class which instances will be merged. Only classes 
     *   returned by {@link #getMergeableClasses} will be passed to this method
     * @return object to be used instead of instances in the lookup
     */
    Object merge(Lookup lookup, Class clazz);

}
