/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2002-2003 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * AntTargetNode.java
 *
 * Created on August 19, 2002, 3:05 PM
 */

package org.netbeans.jellytools.modules.ant.nodes;

import org.netbeans.jemmy.EventTool;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.RepositoryTabOperator;
import org.netbeans.jellytools.actions.ExecuteAction;

import org.netbeans.jellytools.modules.ant.SelectATaskDialog;

import org.netbeans.jemmy.operators.JTreeOperator;

/**
 *
 * @author  mk97936
 */
public class AntTargetNode extends Node {
    
    static final ExecuteAction executeAction = new ExecuteAction();
    
    /** Creates a new instance of AntTargetNode */
    public AntTargetNode(String treePath) {
        super(new RepositoryTabOperator().tree(), treePath);
    }
    
    /** Creates a new instance of AntTargetNode */
    public AntTargetNode(JTreeOperator treeOperator, String treePath) {
        super(treeOperator, treePath);
    }
    
    /** Creates a new instance of AntTargetNode */
    public AntTargetNode(Node parent, String trg) {
        super(parent, trg);
    }
    
    /** performs ExecuteAction with this node */    
    public void execute() {
        executeAction.perform(this);
    }
    
    public void addTask(String tsk) {
        performPopupActionNoBlock("Add" + "|" + Bundle.getString("org.apache.tools.ant.module.nodes.Bundle", // NOI18N
                                                                 "LBL_task_new_type")); // NOI18N
        SelectATaskDialog selectTask = new SelectATaskDialog();        
        selectTask.selectChooseATaskComboBox(tsk);
        selectTask.ok();
    }
    
    public void addDescription() {
        performPopupAction("Add|description");
    }
    
    public void addDirset() {
        performPopupAction("Add|dirset");
    }
    
    public void addFilelist() {
        performPopupAction("Add|filelist");
    }
    
    public void addFileset() {
        performPopupAction("Add|fileset");
    }
    
    public void addFilterset() {
        performPopupAction("Add|filterset");
    }
    
    public void addMapper() {
        performPopupAction("Add|mapper");
    }
    
    public void addPath() {
        performPopupAction("Add|path");
    }
    
    public void addRegexp() {
        performPopupAction("Add|regexp");
    }
    
    public void addPatternset() {
        performPopupAction("Add|patternset");
    }
    
}
