/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * TestTemplates.java
 * NetBeans JUnit based test
 *
 * Created on February 14, 2002, 5:44 PM
 */

package org.netbeans.test.gui.ant;

import java.util.Properties;

import junit.framework.*;
import junit.extensions.TestSetup;

import org.netbeans.junit.*;

import org.netbeans.jemmy.EventTool;

import org.netbeans.jellytools.Bundle;

import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.NewObjectNameStepOperator;
import org.netbeans.jellytools.OptionsOperator;

import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jellytools.properties.Property;

import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.FolderNode;

import org.netbeans.jellytools.actions.NewTemplateAction;

import org.netbeans.jellytools.modules.ant.nodes.AntScriptNode;

import org.apache.tools.ant.module.AntSettings;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.TermOperator;
import org.netbeans.jellytools.actions.PropertiesAction;

/**
 *
 * @author mk97936
 */
public class TestScripts extends JellyTestCase {
    
    String scriptsMountPath = null;
    
    public TestScripts(java.lang.String testName) {
        super(testName);
    }
        
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestScripts.class);

//        TestSuite suite = new NbTestSuite();
//        suite.addTest(new TestScripts("testErrorScript3"));
//        suite.addTest(new TestScripts("testProperty"));
//        suite.addTest(new TestScripts("testVerbosityLevels"));
        
//        TestSetup setup = new TestSetup(suite) {
//            protected void setUp() {
//                if (MainWindowOperator.getDefault().isMDI()) {
//                    String welcomeTitle = Bundle.getStringTrimmed("org.netbeans.modules.welcome.Bundle", 
//                                                                  "LBL_Tab_Title");
//                    EditorOperator ewo = new EditorOperator(welcomeTitle);
//                    ewo.close();
//                }
//            }
//            protected void tearDown() {
//            }
//        };
//        return setup;
        return suite;
    }
    
    public void setUp() {                
        scriptsMountPath = TestUtilities.getMountPointForPkg("org.netbeans.test.gui.ant"); // NOI18N
        new PropertiesAction().perform();
    }
    
    // -------------------------------------------------------------------------
    
    /** TEST METHOD
     * Executes script with custom task definition
     * TODO: output should be checked for message from custom task
     */
    public void testCustom() {    
        executeScriptSaveOut("customscript", scriptsMountPath, "customscript"); // NOI18N
    }
    
    /** TEST METHOD
     * Executes script which executes system rutine
     */
    public void testExecute() {
        executeScriptSaveOut("execute", scriptsMountPath, "execute"); // NOI18N
    }
    
    /** TEST METHOD
     * Executes script which tests all kinds of property definitions
     */
    public void testProperty() {
        AntSettings antSettings = (AntSettings) org.openide.util.Lookup.getDefault().lookup(org.apache.tools.ant.module.AntSettings.class);
        Properties props = antSettings.getProperties();
        props.setProperty("tools.options.property", "Tools_Options_Property");
        antSettings.setProperties(props);
        
        String owt;
        owt = executeScriptSaveOut("property", scriptsMountPath, "property");
        if (owt != null) {
            assertTrue("Value_in_file not in output", owt.indexOf("Value_in_file") > -1); // NOI18N
            assertTrue("Value_in_script not in output", owt.indexOf("Value_in_script") > -1); // NOI18N
            assertTrue("T1_Value_in_file not in output", owt.indexOf("T1_Value_in_file") > -1); // NOI18N
            assertTrue("Tools_Options_Property not in output", owt.indexOf("Tools_Options_Property") > -1); // NOI18N
        }
    }
    
    /** TEST METHOD
     * Creates Sample project from template and executes it
     * TODO: output should be checked for message
     */
    public void testSampleTemplate() {
        TestUtilities.newFromTemplate("SampleProject.xml", "SampleProject", scriptsMountPath + "|" + "Output"); // NOI18N
        executeScriptSaveOut("SampleProject", scriptsMountPath + "|" + "Output", "my-project"); // NOI18N
    }
    
    /** TEST METHOD
     * Creates Blank project from template and executes it
     * TODO: output should be checked for message
     */
    public void testBlankTemplate() {
        TestUtilities.newFromTemplate("Project.xml", "BlankProject", scriptsMountPath + "|" + "Output"); // NOI18N
        executeScriptSaveOut("BlankProject", scriptsMountPath + "|" + "Output", "changeme"); // NOI18N
    }    
    
    /** TEST METHOD
     * Creates Custom Task template
     */
    public void testCustomTemplate() {
        TestUtilities.newFromTemplate("CustomTask.java", "MyCustomTask", scriptsMountPath + "|" + "Output"); // NOI18N
    }
        
    /** TEST METHOD
     * Executes errorneous script (missing taskdef)
     */
    public void testErrorScript1() {
        String errMsg = antTargetFailed;
        String owt = executeFailSaveOut("ErrorScript1", scriptsMountPath, "ErrorProject1", errMsg); // NOI18N
        if (owt != null) {
            assertTrue("Error message is missing.", owt.indexOf("Could not create task or type of type: subelement") > -1); // message from ant tool
        }
    }
    
    /** TEST METHOD
     * Executes errorneous script (wrong subelement)
     */
    public void testErrorScript3() {
        String errMsg = antTargetFailed; 
        String owt = executeFailSaveOut("ErrorScript3", scriptsMountPath, "ErrorProject3", errMsg); // NOI18N
        if (owt != null) {
            assertTrue("Error message is missing.", owt.indexOf("The <delete> type doesn't support the nested") > -1); // message from ant tool
        }
    }
    
    /*
    // TEST METHOD
    public void testErrorScript2() {
        String owt = executeFailSaveOut("ErrorScript2", scriptsMountPath + "|" + "Output");
    }
    // TEST METHOD
    public void testErrorScript4() {
        String owt = executeFailSaveOut("ErrorScript4", scriptsMountPath + "|" + "Output");
    }
    */
    
    /** TEST METHOD
     * 
     */
    public void testAntOptions() {
        
        String antSettings = Bundle.getString("org.netbeans.core.Bundle", "UI/Services/Building") + "|" +
                             Bundle.getString("org.apache.tools.ant.module.resources.Bundle", 
                                              "Services/org-apache-tools-ant-module-AntSettings.settings");
        
        String defaultCompilerLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_compiler");
        String defaultExecutorLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_executor");
        String reuseOutputLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_reuseOutput");
        String saveFilesLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_saveAll");
        String verbosityLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_verbosity");
        
        String doNotCompileLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.loader.Bundle", "LAB_NoCompiler");
        String antScriptExecutionLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.run.Bundle", "LBL_executor");
        String normalLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_info");
        String propertiesLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_properties");
        
        OptionsOperator optionsOper = OptionsOperator.invoke();
        optionsOper.selectOption(antSettings);
        PropertySheetOperator antPropertiesTab = new PropertySheetOperator(optionsOper);
        
        Property defaultCompiler = new Property(antPropertiesTab, defaultCompilerLabel);
        Property defaultExecutor = new Property(antPropertiesTab, defaultExecutorLabel);
        Property reuseOutput = new Property(antPropertiesTab, reuseOutputLabel);
        Property saveFiles = new Property(antPropertiesTab, saveFilesLabel);
        Property verbosity = new Property(antPropertiesTab, verbosityLabel);
        
        assertEquals("Wrong default compiler!", doNotCompileLabel, defaultCompiler.getValue()); // NOI18N
        log(defaultCompiler.getValue());
        assertEquals("Wrong default executor!", antScriptExecutionLabel, defaultExecutor.getValue()); // NOI18N
        log(defaultExecutor.getValue());
        assertEquals("Wrong default reuse option!", "false", reuseOutput.getValue()); // NOI18N
        log(reuseOutput.getValue());
        assertEquals("Wrong default save file option!", "true", saveFiles.getValue()); // NOI18N
        log(saveFiles.getValue());
        assertEquals("Wrong default verbosity level!", normalLabel, verbosity.getValue()); // NOI18N
        log(verbosity.getValue());
        
        Property properties = new Property(antPropertiesTab, propertiesLabel); 
        String propValues = properties.getValue();
        java.util.StringTokenizer st = new java.util.StringTokenizer(propValues, ";"); // NOI18N
        while (st.hasMoreTokens()) {
            log(st.nextToken().trim());
        }
        assertTrue("build.sysclasspath property is missing in Ant Properties!", propValues.indexOf("build.sysclasspath") > -1); // NOI18N
        assertTrue("netbeans.library.path property is missing in Ant Properties!", propValues.indexOf("netbeans.library.path") > -1); // NOI18N
        assertTrue("netbeans.bootclass.path property is missing in Ant Properties!", propValues.indexOf("netbeans.bootclass.path") > -1); // NOI18N
        assertTrue("netbeans.filesystems.path is missing in Ant Properties!", propValues.indexOf("netbeans.filesystems.path") > -1); // NOI18N
        assertTrue("build.compiler.emacs is missing in Ant Properties!", propValues.indexOf("build.compiler.emacs") > -1); // NOI18N
        assertTrue("netbeans.class.path is missing in Ant Properties!", propValues.indexOf("netbeans.class.path") > -1); // NOI18N
        optionsOper.close();
    }
    
    /** TEST METHOD
     * 
     */
    public void testVerbosityLevels() {
        
        String verbosityLevelLabel = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "PROP_verbosity");
        
        String errorsOnly = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_err");
        String warnings = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_warn");
        String normal = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_info");
        String verbose = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_verbose");
        String debugging = Bundle.getStringTrimmed("org.apache.tools.ant.module.Bundle", "LBL_verbosity_debug");
        
        String [] levels = new String [] {errorsOnly, warnings, normal, verbose, debugging};
        String [] msgs = new String [] {"ERR message", "WARN message", "INFO message", "VERBOSE message", "DEBUG message"}; // NOI18N
        
        String antSettings = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "UI/Services/Building") + "|" +
                             Bundle.getStringTrimmed("org.apache.tools.ant.module.resources.Bundle", 
                                              "Services/org-apache-tools-ant-module-AntSettings.settings");
        
        for (int i = 0; i < levels.length; i++) {
            
            OptionsOperator optionsOper = OptionsOperator.invoke();
            optionsOper.selectOption(antSettings);
            PropertySheetOperator antPropertiesTab = new PropertySheetOperator(optionsOper);        
            Property verbosityLevel = new Property(antPropertiesTab, verbosityLevelLabel);
            verbosityLevel.setValue(levels[i]);
            optionsOper.close();
            
            String output = executeScriptSaveOut("testverbosity", scriptsMountPath, "verbosity_test"); // NOI18N
            for (int j = 0; j < i; j++) {
                //System.out.println("msgs["+i+"]=" + msgs[i]);
                assertTrue("Verbosity message is missing: " + msgs[i] + ", for mode: " + levels[i], output.indexOf(msgs[j]) > -1); // NOI18N
            }
            
        }
        
    }
    
    // -------------------------------------------------------------------------
    
    private String executeFailSaveOut(String scriptName, String fileSys, String tabName, String errMsg) {
        
        String owText = null;
        String logFile = null;
        
        new AntScriptNode(fileSys + "|" + scriptName).execute(); // NOI18N
        
        // to wait or not to wait ???
        new EventTool().waitNoEvent(1000);
        
        // check status text
        MainWindowOperator mwo = MainWindowOperator.getDefault();
        mwo.waitStatusText(errMsg);
        
        // grab output from OutputWindow
        TermOperator owo = new TermOperator(tabName);
//        owo.selectPage(tabName);
        owText = owo.getText();
        
        log("<--- OutputWindow text - START --->\n" + owText + // NOI18N
            "<--- OutputWindow text - END --->\n"); // NOI18N
        
        return owText;
        
    }
    
    private String executeScriptSaveOut(String scriptName, String fileSys, String tabName) {
        
        String owText = null;
        String logFile = null;
               
        new AntScriptNode(fileSys + "|" + scriptName).execute(); // NOI18N
        
        // to wait or not to wait ???
        new EventTool().waitNoEvent(1000);
        
        // check status text
        MainWindowOperator mwo = MainWindowOperator.getDefault();
        mwo.waitStatusText(finishedTargets);
        
        // grab output from OutputWindow
        TermOperator owo = new TermOperator(tabName);
//        owo.selectPage(tabName);
        owText = owo.getText();
        
        log("<--- OutputWindow text - START --->\n" + owText + // NOI18N
            "<--- OutputWindow text - END --->\n"); // NOI18N
        
        assertTrue(buildSuccessful + " not printed to Output Window", owText.indexOf(buildSuccessful) > -1); // NOI18N
        
        owo.close();
        
        return owText;
        
    }
    
    /*
    public String buildSuccessful = Bundle.getStringTrimmed("org.apache.tools.ant.module.bridge.impl.Bundle", "MSG_finished_target_printed");
    public String finishedTargets = Bundle.getStringTrimmed("org.apache.tools.ant.module.bridge.impl.Bundle", "MSG_finished_target_status");
    public String antTargetFailed = Bundle.getStringTrimmed("org.apache.tools.ant.module.bridge.impl.Bundle", "MSG_target_failed_status");
     */
    //hotfix: org.apache.tools.ant.module.bridge.impl.Bundle is invisible for test, Bundle is located in $IDE/ant/nblib/bridge.jar 
    //I must use hardcoded String for now
    public String buildSuccessful = "BUILD SUCCESSFUL";
    public String finishedTargets = "Finished Ant target(s).";
    public String antTargetFailed = "Ant target failed.";

    public String saveAllFinished = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "MSG_AllSaved");
    
}
